const whitespace = require('is-whitespace-character');

const {
    CH_LESS_THAN, CH_DOT, CH_COMMA,
    CH_COLON, CH_SEMICOLON, CH_QUOTE,
    CH_APOSTROPHE, CH_RIGHT_PARENTHESIS, CH_RIGHT_SQUARE_BRACKET,
    CH_LEFT_PARENTHESIS, CH_LEFT_SQUARE_BRACKET,
} = require('../utils/charcodes');

module.exports.eatUrl = (index, value) => {
    const length = value.length;
    let queue = '';
    let parenCount = 0;

    while (index < length) {
        let charcode = value.charCodeAt(index);

        if (whitespace(charcode) || charcode === CH_LESS_THAN) {
            break;
        }

        if (
            charcode === CH_DOT ||
            charcode === CH_COMMA ||
            charcode === CH_COLON ||
            charcode === CH_SEMICOLON ||
            charcode === CH_QUOTE ||
            charcode === CH_APOSTROPHE ||
            charcode === CH_RIGHT_PARENTHESIS ||
            charcode === CH_RIGHT_SQUARE_BRACKET
        ) {
            let nextCharacter = value.charCodeAt(index + 1);

            if (isNaN(nextCharacter) || whitespace(nextCharacter)) {
                break;
            }
        }

        if (charcode === CH_LEFT_PARENTHESIS || charcode === CH_LEFT_SQUARE_BRACKET) {
            parenCount++;
        }

        if (charcode === CH_RIGHT_PARENTHESIS || charcode === CH_RIGHT_SQUARE_BRACKET) {
            parenCount--;

            if (parenCount < 0) {
                break;
            }
        }

        queue += value.charAt(index);
        index++;
    }

    return [index, queue];
};
