const {
    isCommonmarkWhitespace,
    findTailIndex,
    checkLeftFlankingDelimiterRunBounds,
} = require('../utils/spec');

const inlinePairedText = function inlinePairedText([char, charTimes, strict], type) {
    const chars = char.repeat(charTimes);

    function womInlinePaired(eat, value, silent) {
        const length = value.length;
        const openingInitialIndex = 0;
        let openingFollowingIndex = openingInitialIndex;

        // Инлайн токены должны начинатся непосредственно с токенов,
        // так как экранирование должно отработать раньше
        // Съедаем жадно все токены, идущие подряд
        while (openingFollowingIndex < length && value[openingFollowingIndex] === char) {
            openingFollowingIndex += 1;
        }

        if (openingFollowingIndex < charTimes) {
            return false;
        }

        // Ранний выход если разделитель невалиден
        if (!checkLeftFlankingDelimiterRunBounds(value, openingInitialIndex, openingFollowingIndex, strict)) {
            return false;
        }

        const closingInitialIndex = findTailIndex(value, openingFollowingIndex, char, charTimes, strict);

        if (closingInitialIndex < 0) {
            return false;
        }

        if (silent) {
            return true;
        }

        const outer = value.slice(openingInitialIndex, closingInitialIndex + charTimes);
        const inner = value.slice(openingInitialIndex + charTimes, closingInitialIndex);

        const now = eat.now();

        now.offset += charTimes;
        now.column += charTimes;

        eat(outer)({
            type,
            children: this.tokenizeInline(inner, now),
        });

        return true;
    }

    function defaultLocator(value, fromIndex) {
        return value.indexOf(chars, fromIndex);
    }

    function strictLocator(value, fromIndex) {
        const index = defaultLocator(value, fromIndex);

        if (index < 0) {
            return index;
        }

        if (isCommonmarkWhitespace(value, index - 1)) {
            return index;
        }

        return -1;
    }

    womInlinePaired.locator = strict ?
        strictLocator :
        defaultLocator;

    return womInlinePaired;
};

module.exports.inlinePairedText = inlinePairedText;
