const { createMdAstWomCutNode } = require('./tokenize-skip-node/wom-cut');
const { createMdAstWomFormatterNode } = require('./tokenize-skip-node/wom-formatter');
const { createMdAstWomMarkdownNode } = require('./tokenize-skip-node/wom-markdown');
const { createMdAstWomHtmlNode } = require('./tokenize-skip-node/wom-html');
const { createMdAstWomTableNode } = require('./tokenize-skip-node/wom-table');
const { createMdAstWomBlockNode } = require('./tokenize-skip-node/wom-block');
const { createMdAstWomBlockquoteNode } = require('./tokenize-skip-node/wom-blockquote');
const { createMdAstWomEscapeNode } = require('./tokenize-skip-node/wom-escape');
const { createMdAstWomMonospaceNode } = require('./tokenize-skip-node/wom-monospace');
const { createMdAstMdCodeNode } = require('./tokenize-skip-node/code');
const { createMdAstMdInlineCodeNode } = require('./tokenize-skip-node/inline-code');
const { createMdAstDefaultNode } = require('./tokenize-skip-node/wom-default');

/*
 * Эта функция преобразовывает валидный узел из парсера utils/parse-container-at
 * в MDAST узел.
 */
function createMdAstNode(self, value, location, node) {
    const { type } = node;

    switch (type) {
        case 'womCut':
            return createMdAstWomCutNode(self, value, location, node);

        case 'womFormatter':
            return createMdAstWomFormatterNode(self, value, location, node);

        case 'womHtml':
            return createMdAstWomHtmlNode(self, value, location, node);

        case 'womMarkdown':
            return createMdAstWomMarkdownNode(self, value, location, node);

        case 'womTable':
            return createMdAstWomTableNode(self, value, location, node);

        case 'womEscape':
            return createMdAstWomEscapeNode(self, value, location, node);

        case 'womMonospace':
            return createMdAstWomMonospaceNode(self, value, location, node);

        case 'code':
            return createMdAstMdCodeNode(self, value, location, node);

        case 'inlineCode':
            return createMdAstMdInlineCodeNode(self, value, location, node);

        case 'womBlock':
            return createMdAstWomBlockNode(self, value, location, node);

        case 'womBlockquote':
            return createMdAstWomBlockquoteNode(self, value, location, node);

        default:
            return createMdAstDefaultNode(self, value, location, node);
    }
}

exports.createMdAstNode = createMdAstNode;
