const {
    getNodeInnerText,
    trimFollowingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');

function createMdAstMdCodeNode(self, value, location, node) {
    trimPrecedingBlankLine(value, node);
    trimFollowingSpacing(value, node);

    const { type, attributes: { format: lang } } = node;

    return {
        type,
        lang: lang || null,
        meta: null,
        value: getNodeInnerText(value, node),
    };
}

exports.createMdAstMdCodeNode = createMdAstMdCodeNode;
