const { isLineFeedChar } = require('../../utils/spec');
const { getNodeInnerText } = require('../../utils/skip-blocks-utils');

function shiftLocation(location, value, fromIndex, nextIndex) {
    const l = Math.min(nextIndex, value.length);

    for (let i = fromIndex; i < l; i += 1) {
        location.offset += 1;

        if (isLineFeedChar(value, i)) {
            location.line += 1;
            location.column = 1;
        } else {
            location.column += 1;
        }
    }
}

function tokenizeInlineChildren(self, value, location, node) {
    return self.tokenizeInline(getNodeInnerText(value, node), location);
}

function tokenizeBlockChildren(self, value, location, node) {
    return self.tokenizeBlock(getNodeInnerText(value, node), location);
}

exports.tokenizeInlineChildren = tokenizeInlineChildren;
exports.tokenizeBlockChildren = tokenizeBlockChildren;
exports.shiftLocation = shiftLocation;
