const {
    trimFollowingSpacing,
    trimPrecedingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');
const {
    shiftLocation,
    tokenizeBlockChildren,
} = require('./utils');

function createMdAstWomBlockInlineNode(self, value, location, node) {
    const {
        type,
        inline,
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingSpacing(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        // Внутри womBlock(inline) поддерживается блочный контент
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        children,
    };
}

function createMdAstWomBlockBlockNode(self, value, location, node) {
    const {
        type,
        inline,
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingBlankLine(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        children,
    };
}

function createMdAstWomBlockNode(self, value, location, node) {
    if (node.inline) {
        return createMdAstWomBlockInlineNode(self, value, location, node);
    }

    return createMdAstWomBlockBlockNode(self, value, location, node);
}

exports.createMdAstWomBlockBlockNode = createMdAstWomBlockBlockNode;
exports.createMdAstWomBlockInlineNode = createMdAstWomBlockInlineNode;
exports.createMdAstWomBlockNode = createMdAstWomBlockNode;
