const {
    trimFollowingSpacing,
    trimPrecedingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');
const {
    shiftLocation,
    tokenizeBlockChildren,
} = require('./utils');

function createMdAstWomBlockquoteInlineNode(self, value, location, node) {
    const {
        type,
        inline,
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingSpacing(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        // Внутри womBlockquote(inline) поддерживается блочный контент
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        children,
    };
}

function createMdAstWomBlockquoteBlockNode(self, value, location, node) {
    const {
        type,
        inline,
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingBlankLine(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        children,
    };
}

function createMdAstWomBlockquoteNode(self, value, location, node) {
    if (node.inline) {
        return createMdAstWomBlockquoteInlineNode(self, value, location, node);
    }

    return createMdAstWomBlockquoteBlockNode(self, value, location, node);
}

exports.createMdAstWomBlockquoteInlineNode = createMdAstWomBlockquoteInlineNode;
exports.createMdAstWomBlockquoteBlockNode = createMdAstWomBlockquoteBlockNode;
exports.createMdAstWomBlockquoteNode = createMdAstWomBlockquoteNode;
