const {
    trimFollowingSpacing,
    trimPrecedingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');
const {
    shiftLocation,
    tokenizeBlockChildren,
} = require('./utils');

function createMdAstWomCutInlineNode(self, value, location, node) {
    const {
        type,
        inline,
        attributes,
    } = node;

    const contentLocation = { ...location };

    // Сдвигаем location до title
    shiftLocation(location, value, node.openingInitialIndex, node.openingFollowingIndex);

    const title = self.tokenizeBlock(attributes.title, location);

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingSpacing(value, node);

    if (node.children.length > 0) {
        // Сдвигаем location до контента
        shiftLocation(contentLocation, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeBlockChildren(self, value, contentLocation, node);
    }

    // Внутри womCut поддерживается блочный контент
    return {
        type,
        inline,
        title,
        children,
    };
}

function createMdAstWomCutBlockNode(self, value, location, node) {
    const {
        type,
        inline,
        attributes,
    } = node;

    const contentLocation = { ...location };

    // Сдвигаем location до title
    shiftLocation(location, value, node.openingInitialIndex, node.openingFollowingIndex);

    const title = self.tokenizeBlock(attributes.title, location);

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingBlankLine(value, node);

    if (node.children.length > 0) {
        // Сдвигаем location до контента
        shiftLocation(contentLocation, value, node.openingInitialIndex, node.children[0].openingInitialIndex);

        children = tokenizeBlockChildren(self, value, contentLocation, node);
    }

    return {
        type,
        inline,
        title,
        children,
    };
}

function createMdAstWomCutNode(self, value, location, node) {
    if (node.inline) {
        return createMdAstWomCutInlineNode(self, value, location, node);
    }

    return createMdAstWomCutBlockNode(self, value, location, node);
}

exports.createMdAstWomCutInlineNode = createMdAstWomCutInlineNode;
exports.createMdAstWomCutBlockNode = createMdAstWomCutBlockNode;
exports.createMdAstWomCutNode = createMdAstWomCutNode;
