const {
    trimFollowingSpacing,
    trimPrecedingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');
const {
    shiftLocation,
    tokenizeInlineChildren,
    tokenizeBlockChildren,
} = require('./utils');

function createMdAstDefaultInlineNode(self, value, location, node) {
    const {
        type,
        inline,
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingSpacing(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeInlineChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        children,
    };
}

function createMdAstDefaultBlockNode(self, value, location, node) {
    const {
        type,
        inline,
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingBlankLine(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        children,
    };
}

function createMdAstDefaultNode(self, value, location, node) {
    if (node.inline) {
        return createMdAstDefaultInlineNode(self, value, location, node);
    }

    return createMdAstDefaultBlockNode(self, value, location, node);
}

exports.createMdAstDefaultNode = createMdAstDefaultNode;
