const {
    getNodeOuterText,
    trimPrecedingBlankLine,
    trimEqualSpacingAround,
} = require('../../utils/skip-blocks-utils');

function getFormatterText(value, { children }) {
    const chunks = [];
    const l = children.length;

    for (let i = 0; i < l; i += 1) {
        const node = children[i];
        const text = getNodeOuterText(value, node)
            .replace(/~(%{2,})/g, '$1');

        chunks.push(text);
    }

    return chunks.join('');
}

function createMdAstWomFormatterInlineNode(self, value, location, node) {
    trimEqualSpacingAround(value, node);

    const {
        type,
        inline,
        attributes: { format, params: attributes },
    } = node;

    const mdAstNode = {
        type,
        inline,
        value: getFormatterText(value, node),
    };

    if (format) {
        mdAstNode.format = format;
        mdAstNode.attributes = attributes;
    }

    return mdAstNode;
}

function createMdAstWomFormatterBlockNode(self, value, location, node) {
    trimPrecedingBlankLine(value, node);

    const {
        type,
        inline,
        attributes: { format, params: attributes },
    } = node;

    const mdAstNode = {
        type,
        inline,
        value: getFormatterText(value, node),
    };

    if (format) {
        mdAstNode.format = format;
        mdAstNode.attributes = attributes;
    }

    return mdAstNode;
}

function createMdAstWomFormatterNode(self, value, location, node) {
    if (node.inline) {
        return createMdAstWomFormatterInlineNode(self, value, location, node);
    }

    return createMdAstWomFormatterBlockNode(self, value, location, node);
}

exports.createMdAstWomFormatterInlineNode = createMdAstWomFormatterInlineNode;
exports.createMdAstWomFormatterBlockNode = createMdAstWomFormatterBlockNode;
exports.createMdAstWomFormatterNode = createMdAstWomFormatterNode;
