const {
    trimFollowingSpacing,
    trimPrecedingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');
const {
    shiftLocation,
    tokenizeBlockChildren,
} = require('./utils');

function createMdAstWomMarkdownInlineNode(self, value, location, node) {
    const {
        type,
        inline,
        attributes: { format, params: attributes },
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingSpacing(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        format,
        attributes,
        children,
    };
}

function createMdAstWomMarkdownBlockNode(self, value, location, node) {
    const {
        type,
        inline,
        attributes: { format, params: attributes },
    } = node;

    let children = [];

    trimFollowingSpacing(value, node);
    trimPrecedingBlankLine(value, node);

    if (node.children.length > 0) {
        shiftLocation(location, value, node.openingInitialIndex, node.children[0].openingInitialIndex);
        children = tokenizeBlockChildren(self, value, location, node);
    }

    return {
        type,
        inline,
        format,
        attributes,
        children,
    };
}

function createMdAstWomMarkdownNode(self, value, location, node) {
    if (node.inline) {
        return createMdAstWomMarkdownInlineNode(self, value, location, node);
    }

    return createMdAstWomMarkdownBlockNode(self, value, location, node);
}

exports.createMdAstWomMarkdownInlineNode = createMdAstWomMarkdownInlineNode;
exports.createMdAstWomMarkdownBlockNode = createMdAstWomMarkdownBlockNode;
exports.createMdAstWomMarkdownNode = createMdAstWomMarkdownNode;
