const {
    trimFollowingSpacing,
    trimPrecedingBlankLine,
} = require('../../utils/skip-blocks-utils');
const {
    shiftLocation,
    tokenizeBlockChildren,
} = require('./utils');

function createMdAstWomTableNode(self, value, location, node) {
    const children = [];
    const lineLength = node.children.length;
    let prevInfo = location;
    let prevOffset = node.openingInitialIndex;

    for (let lineIndex = 0; lineIndex < lineLength; lineIndex += 1) {
        const lineNode = node.children[lineIndex];

        if (lineNode.type !== 'womTableRow') {
            // Все что сверстано между строками таблицы – игнорируем
            continue;
        }

        const cells = [];

        children.push({
            type: lineNode.type,
            children: cells,
        });

        const cellLength = lineNode.children.length;

        for (let cellIndex = 0; cellIndex < cellLength; cellIndex += 1) {
            const cellNode = lineNode.children[cellIndex];

            trimFollowingSpacing(value, cellNode);
            trimPrecedingBlankLine(value, cellNode);

            let children = [];

            if (cellNode.children.length > 0) {
                prevInfo = { ...prevInfo };
                const nextOffset = cellNode.children[0].innerFirstIndex;
                shiftLocation(prevInfo, value, prevOffset, nextOffset);
                prevOffset = nextOffset;

                children = tokenizeBlockChildren(self, value, prevInfo, cellNode);
            }

            cells.push({
                type: cellNode.type,
                children,
            });
        }
    }

    const {
        type,
        inline,
        attributes: { kind },
    } = node;

    return {
        type,
        inline,
        kind,
        children,
    };
}

exports.createMdAstWomTableNode = createMdAstWomTableNode;
