class Ctx {
    constructor(value) {
        this.value = value;
        this.index = 0;
    }

    cut(size) {
        this.index += size;
        let since = this.index - size;
        return this.value.slice(since, this.index);
    }
}

function womBlockGenerator(type, openingSeq, closingSeq, { eatFirst, inline }) {
    const startSeqLen = openingSeq.length;
    const endSeqLen = closingSeq.length;

    function womBlock(eat, value, silent) {
        const ctx = new Ctx(value);

        if (ctx.value.indexOf(openingSeq, ctx.index) !== ctx.index) {
            return false;
        }

        ctx.cut(startSeqLen);

        const lastIndex = ctx.value.indexOf(closingSeq, ctx.index);

        if (lastIndex === -1) {
            return false;
        }

        const props = eatFirst.call(this, ctx);

        if (props === false) {
            return false;
        }

        if (silent) {
            // Блок распарсился в режиме silent для interrupt
            return true;
        }

        const inner = ctx.cut(lastIndex - ctx.index);

        ctx.cut(endSeqLen);

        props.value = inner;

        const mdastNode = {
            type,
            inline,
            ...props,
        };

        eat(ctx.value.slice(0, ctx.index))(mdastNode);

        return true;
    }

    if (inline) {
        womBlock.locator = (value, index) => value.indexOf(openingSeq, index);
    }

    return womBlock;
}

module.exports = womBlockGenerator;
