module.exports = [
    {
        group: 'womAction {{}}',
        tests: [
            {
                markup: 'blablaska {{linkstree root=HomePage }}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'text',
                                    value: 'blablaska ',
                                },
                                {
                                    type: 'womAction',
                                    inline: true,
                                    name: 'linkstree',
                                    params: {
                                        root: 'HomePage',
                                    },
                                },
                            ],
                        },
                    ],
                },
            },
            {
                markup: '   {{iframe}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'iframe',
                            params: {},
                        },
                    ],
                },
            },
            {
                markup: '{{\nGrid\npage="/test"\nreadonly="1"\n}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'grid',
                            params: {
                                page: '/test',
                                readonly: '1',
                            },
                        },
                    ],
                },
            },
            {
                markup: '{{\ngrid\npage="/test"\nreadonly="1"\n}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'grid',
                            params: {
                                page: '/test',
                                readonly: '1',
                            },
                        },
                    ],
                },
            },
            {
                markup: '{{grid\npage="/test"\nreadonly="1"\n}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'grid',
                            params: {
                                page: '/test',
                                readonly: '1',
                            },
                        },
                    ],
                },
            },
            {
                markup: '{{iframe src="https://wiki.woofmd-team.ru" frameborder=0 width=700px height=600px scrolling=no}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'iframe',
                            params: {
                                src: 'https://wiki.woofmd-team.ru',
                                frameborder: '0',
                                width: '700px',
                                height: '600px',
                                scrolling: 'no',
                            },
                        },
                    ],
                },
            },
            {
                markup: '{{linkstree}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'linkstree',
                            params: {},
                        },
                    ],
                },
            },
            {
                markup: '{{ linkstree root=HomePage levels }}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'linkstree',
                            params: {
                                root: 'HomePage',
                                levels: null,
                            },
                        },
                    ],
                },
            },
            {
                markup: '{{linkstree root=HomePage levels}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'linkstree',
                            params: {
                                root: 'HomePage',
                                levels: null,
                            },
                        },
                    ],
                },
            },
            {
                markup: '{{a}}{{anchor}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'womAction',
                                    inline: true,
                                    name: 'a',
                                    params: {},
                                },
                                {
                                    type: 'womAction',
                                    inline: true,
                                    name: 'anchor',
                                    params: {},
                                },
                            ],
                        },
                    ],
                },
            },
            {
                markup: '{{a}} text {{anchor}}',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'womAction',
                                    inline: true,
                                    name: 'a',
                                    params: {},
                                },
                                {
                                    type: 'text',
                                    value: ' text ',
                                },
                                {
                                    type: 'womAction',
                                    inline: true,
                                    name: 'anchor',
                                    params: {},
                                },
                            ],
                        },
                    ],
                },
            },
            {
                markup: 'test\n{{a name=x}}\ntest',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'text',
                                    value: 'test'
                                }
                            ]
                        },
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'a',
                            params: {
                                name: 'x'
                            },
                        },
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'text',
                                    value: 'test'
                                }
                            ]
                        },
                    ]
                }
            },
            {
                markup: 'test\n\n{{a name=x}}\n\ntest',
                expect: {
                    type: 'root',
                    children: [
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'text',
                                    value: 'test'
                                }
                            ]
                        },
                        {
                            type: 'womAction',
                            inline: false,
                            name: 'a',
                            params: {
                                name: 'x'
                            },
                        },
                        {
                            type: 'paragraph',
                            children: [
                                {
                                    type: 'text',
                                    value: 'test'
                                }
                            ]
                        },
                    ]
                }
            }
        ],
    },
];
