const { isWhitespaceChar } = require('../utils/spec');
const {
    parseWomActionHeader,
    parseContainerParams,
    skipLineFollowingSpacing,
} = require('../utils/skip-blocks-utils');

function womAction({ inline, names }) {
    const namesSet = new Set(names);

    function tokenizer(eat, value, silent) {
        let fromIndex = 0;

        if (!inline) {
            // Eat initial spacing
            while (isWhitespaceChar(value, fromIndex)) {
                fromIndex += 1;
            }
        }

        if (value[fromIndex] !== '{' || value[fromIndex + 1] !== '{') {
            return false;
        }

        const { format, offset, params } = parseWomActionHeader(value, fromIndex);

        if (!format || !namesSet.has(format)) {
            return false;
        }

        if (!inline && skipLineFollowingSpacing(value, offset) < 0) {
            return false;
        }

        if (silent) {
            return true;
        }

        eat(value.slice(0, offset))({
            type: 'womAction',
            inline,
            name: format,
            params: parseContainerParams(params)
        });

        return true;
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('{{', fromIndex);

    return tokenizer;
}

exports.womAction = womAction;
