module.exports = [
    {
        group: 'Wom-блок {[]}',
        tests: [
            {
                markup: '{[\ntest\n]}',
                expect: { type: 'root', children: [
                    { type: 'womBlock', inline: false, children: [
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'test' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '{[\n\nx\n\n{[\n\nx\n\n]}\n\nx\n\n]}',
                expect: { type: 'root', children: [
                    { type: 'womBlock', inline: false, children: [
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x' },
                        ] },
                        { type: 'womBlock', inline: false, children: [
                            { type: 'paragraph', children: [
                                { type: 'text', value: 'x' },
                            ] },
                        ] },
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '{[\nx\n\n{[\nx\n]}\nx\n]}',
                expect: { type: 'root', children: [
                    { type: 'womBlock', inline: false, children: [
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x' },
                        ] },
                        { type: 'womBlock', inline: false, children: [
                            { type: 'paragraph', children: [
                                { type: 'text', value: 'x' },
                            ] },
                        ] },
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '{[\nx\n{[\nx\n]}\nx\n]}',
                expect: { type: 'root', children: [
                    { type: 'womBlock', inline: false, children: [
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x' },
                        ] },
                        { type: 'womBlock', inline: false, children: [
                            { type: 'paragraph', children: [
                                { type: 'text', value: 'x' },
                            ] },
                        ] },
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '{[\nx\n{[x]}\nx\n]}',
                expect: { type: 'root', children: [
                    { type: 'womBlock', inline: false, children: [
                        { type: 'paragraph', children: [
                            { type: 'text', value: 'x\n' },
                            { type: 'womBlock', inline: true, children: [
                                { type: 'paragraph', children: [
                                    { type: 'text', value: 'x' },
                                ] },
                            ] },
                            { type: 'text', value: '\nx' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '{[test]}',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'womBlock', inline: true, children: [
                            { type: 'paragraph', children: [
                                { type: 'text', value: 'test' },
                            ] },
                        ] },
                    ] },
                ] },
            },
        ],
    },
];
