const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const {
    createMdAstWomBlockInlineNode,
    createMdAstWomBlockBlockNode,
} = require('../lib/tokenize-skip-node/wom-block');
const {
    inlineWomBlock,
    blockWomBlock,
} = require('../utils/skip-blocks');

function womBlock({ inline }) {
    const container = inline ?
        inlineWomBlock :
        blockWomBlock;
    const createMdAstWomBlockNode = inline ?
        createMdAstWomBlockInlineNode :
        createMdAstWomBlockBlockNode;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomBlockNode(this, value, now, outerNode)
        );

        return true;
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('{[', fromIndex);

    return tokenizer;
}

exports.womBlock = womBlock;
