const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const {
    createMdAstWomBlockquoteInlineNode,
    createMdAstWomBlockquoteBlockNode,
} = require('../lib/tokenize-skip-node/wom-blockquote');
const {
    inlineWomBlockquote,
    blockWomBlockquote,
} = require('../utils/skip-blocks');

function womBlockquote({ inline }) {
    const container = inline ?
        inlineWomBlockquote :
        blockWomBlockquote;
    const createMdAstWomBlockquoteNode = inline ?
        createMdAstWomBlockquoteInlineNode :
        createMdAstWomBlockquoteBlockNode;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomBlockquoteNode(this, value, now, outerNode)
        );

        return true;
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('<[', fromIndex);

    return tokenizer;
}

exports.womBlockquote = womBlockquote;
