const WOM_COLOR_RE = /^#([0-9a-f]{3}|[0-9a-f]{6})\b/i;

function womColor(eat, value, silent) {
    const index = womColor.locator(value, 0);
    if (index !== 0) {
        return false;
    }

    const [raw, color] = value.slice(index, 7).match(WOM_COLOR_RE) || [];
    if (!raw) {
        return false;
    }
    if (silent) {
        return true;
    }

    return eat(raw)({ type: 'color', value: color.toLowerCase(), raw });
}
womColor.locator = (value, index) => value.indexOf('#', index);

module.exports = womColor;
