const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const {
    createMdAstWomCutInlineNode,
    createMdAstWomCutBlockNode,
} = require('../lib/tokenize-skip-node/wom-cut');
const {
    inlineWomCut,
    blockWomCut,
} = require('../utils/skip-blocks');

function womCut({ inline }) {
    const container = inline ?
        inlineWomCut :
        blockWomCut;
    const createMdAstWomCutNode = inline ?
        createMdAstWomCutInlineNode :
        createMdAstWomCutBlockNode;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomCutNode(this, value, now, outerNode)
        );
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('<{', fromIndex);

    return tokenizer;
}

exports.womCut = womCut;
