const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const { stringWomEscape } = require('../utils/skip-blocks');
const { createMdAstWomEscapeNode } = require('../lib/tokenize-skip-node/wom-escape');

function womEscapeTilde(eat, value) {
    const outerNode = parseTheContainerAt(stringWomEscape, value, 0);
    const { outerFirstIndex } = outerNode;

    if (outerFirstIndex < 0) {
        return false;
    }

    const now = eat.now();

    eat(getNodeOuterText(value, outerNode))(
        createMdAstWomEscapeNode(this, value, now, outerNode)
    );

    return true;
}

womEscapeTilde.locator = (value, fromIndex) =>
    value.indexOf('~', fromIndex);

module.exports = womEscapeTilde;
