## Форматтеры и другое на базе процентиков (formatter, markdown)

〉Инлайн vs Блок
←text %%niagara.yandex.net%% text
←
←%%
←niagara.yandex.net
←niagara.yandex.net
←%%
→ {type: 'root', children: [
→   {type: 'paragraph', children: [
→     {type: 'text', value: 'text '},
→     {type: 'womFormatter', inline: true, inline: true, value: 'niagara.yandex.net'},
→     {type: 'text', value: ' text'},
→   ]},
→   {type: 'womFormatter', inline: true, inline: false, value: "niagara.yandex.net\nniagara.yandex.net\n"},
→ ]}

〉Инлайн вставки форматтера
←Вообще-то для %%моноширинного%% текста %%есть другая%% конструкция.
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'Вообще-то для '},
→   {type: 'womFormatter', inline: true, value: 'моноширинного'},
→   {type: 'text', value: ' текста '},
→   {type: 'womFormatter', inline: true, value: 'есть другая'},
→   {type: 'text', value: ' конструкция.'},
→ ]}

〉Инлайн вставки форматтера с выравниванием
←So %%kusok%% then %%(wacko wrapper=right) wacko-shmako %% and %%this one%% at the end
→ [
→   {type: 'text', value: 'So '},
→   {type: 'womFormatter', inline: true, value: 'kusok'},
→   {type: 'text', value: ' then '},
→   {type: 'womMarkdown', inline: true, format: 'wacko', attributes: {wrapper: 'right'}, children: [
→         {type: 'paragraph', children: [
→           {type: 'text', value: 'wacko-shmako'}
→         ]},
→   ]},
→   {type: 'text', value: ' and '},
→   {type: 'womFormatter', inline: true, value: 'this one'},
→   {type: 'text', value: ' at the end'}
→ ]

〉Форматтер битым куском
←Начинаем %%(js) и не заканчиваем
→ {type: 'text', value: 'Начинаем %%(js) и не заканчиваем'}

〉Жирный форматтер
←Жир **%%code%%** ?
→ [{type: 'text', value: 'Жир '},
→  {type: 'strong', children: [{type: 'womFormatter', inline: true, value: 'code'}]},
→  {type: 'text', value: ' ?'},
→ ]

〉Форматтер с множественными %%
←%%
←Hello
←%%%%%%%%%%%%%%%
←World
←%%%%%%%%%%%%%%%
←%%
→ {"type":"root","children":[
→   {"type":"womFormatter","inline":false,"value":"Hello\n%%%%%%%%%%%%%"},
→   {type: 'paragraph', children: [{type: 'text', value: 'World'}]},
→   {"type":"womFormatter","inline":false,"value":"%%%%%%%%%%%%%\n"},
→ ]}

〉css formatter wrapper
←%%(css nomark wrapper=box align=left width=270 border=0 nomark)
←.d { font-size:70% }
←%%
→ {type: 'root', children: [{type: 'womFormatter', inline: false, format: 'css', attributes: {nomark: null, wrapper: 'box', align: 'left', width: '270', border: '0'}, value: '.d { font-size:70% }\n'}]}

〉javascript formatter
←%%(javascript nomark wrapper=box border="5px dashed red")
←alert("hooray!");
←%%
→ {type: 'root', children: [{type: 'womFormatter', inline: false, format: 'javascript', attributes: {nomark: null, wrapper: 'box', border: '5px dashed red'}, value: 'alert("hooray!");\n'}]}

〉css formatter
←%%(css nomark wrapper=shade)
←.d2 { font-size:70% }
←%%
→ {type: 'root', children: [
→   {type: 'womFormatter', inline: false, format: 'css',
→     attributes: {nomark: null, wrapper: 'shade'},
→     value: '.d2 { font-size:70% }\n'}]}

〉wacko text aligned
←%%(wacko wrapper=text align=center) текст по центру %%
→ {type: 'root', children: [
→ {type: 'womMarkdown', inline: false, format: 'wacko',
→   attributes: {wrapper: 'text', align: 'center'},
→   children: [
→     {type: 'paragraph', children: [
→         {type: 'text', value: 'текст по центру'}
→     ]}
→   ]}
→ ]}

〉wacko page wrapper
←%%(wacko wrapper=page wrapper_width=200) этот текст не может быть шире двухсот пикселей%%
→ {type: 'root', children: [
→   {type: 'womMarkdown', inline: false, format: 'wacko',
→     attributes: {wrapper: 'page', wrapper_width: '200'},
→     children: [
→       {type: 'paragraph', children: [
→         {type: 'text', value: 'этот текст не может быть шире двухсот пикселей'}
→       ]}
→   ]}
→ ]}

〉markdown page wrapper should parse inner markdown
←%%(markdown) `code` and **bold** %%
→ {type: 'root', children: [
→   {type: 'womMarkdown', inline: false, format: 'markdown',
→     attributes: {},
→     children: [
→         {type: 'paragraph', children: [
→           {type: 'inlineCode', value: 'code'},
→           {type: 'text', value: ' and '},
→           {type: 'strong', children: [{type: 'text', value: 'bold'}]},
→         ]}
→     ]}
→]}

〉Пример 2: nomark
←%%(python nomark)
←@requires_authorization
←def somefunc(param1, param2):
←    r'''A docstring'''
←%%
→ { type: 'root', children: [
→   { type: 'womFormatter', inline: false,
→     format: 'python',
→     attributes: {nomark: null},
→     value: `@requires_authorization\ndef somefunc(param1, param2):\n    r'''A docstring'''\n`
→   } ] }


〉Пример 3: язык с заглавной буквы
←%%(Python)
←from django.contrib.auth.models import Group, Permission
←different_users = Group(name='Different Users')
←different_users.save()
←%%
→ { type: 'root', children: [
→   { type: 'womFormatter', inline: false,
→     format: 'python',
→     attributes: {},
→     value: `from django.contrib.auth.models import Group, Permission\ndifferent_users = Group(name='Different Users')\ndifferent_users.save()\n`
→   } ] }

〉Пример 4: небуквенный символ в языке
←%%(c++)
←fronm django.contrib.auth.models import Group, Permission
←different_users = Group(name='Different Users')
←different_users.save()
←%%
→ { type: 'root', children: [
→   { type: 'womFormatter', inline: false,
→     format: 'c++',
→     attributes: {},
→     value: `fronm django.contrib.auth.models import Group, Permission\ndifferent_users = Group(name='Different Users')\ndifferent_users.save()\n`
→   } ] }

〉Пример 5: язык из одного символа
←%%(c)
←from django.contrib.auth.models import Group, Permission
←different_users = Group(name='Different Users')
←different_users.save()
←%%
→ { type: 'root', children: [
→   { type: 'womFormatter', inline: false,
→     format: 'c',
→     attributes: {},
→     value: `from django.contrib.auth.models import Group, Permission\ndifferent_users = Group(name='Different Users')\ndifferent_users.save()\n`
→   } ] }

〉Пример 6: язык из цифр
←%%(123)
←value
←%%
→ { type: 'root', children: [
→   { type: 'womFormatter', inline: false,
→     format: '123',
→     attributes: {},
→     value: `value\n`
→   } ] }

〉Cut с питон функцией
←<{код функции
←%%(js)
←function is_pretty_num(n) { return 1; }
←%%
←}>
→ { type: 'root', children: [ { type: 'womCut', inline: false,
→   title: [{type: 'paragraph', children: [{type: 'text', value: 'код функции'}]}],
→   children: [
→     { type: 'womFormatter', inline: false,
→       format: 'js',
→       attributes: {},
→       value: `function is_pretty_num(n) { return 1; }\n`
→     } ] } ] }

〉math outline 1
←%%(math outline)\int\limits_{-\infty}^{+\infty} e^{-x^2/2} \frac{-b \pm \sqrt{b^2 - 4ac}}{2a} %%
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womFormatter', inline: true, format: 'math', attributes: {outline: null},
→     value: '\\int\\limits_{-\\infty}^{+\\infty} e^{-x^2/2} \\frac{-b \\pm \\sqrt{b^2 - 4ac}}{2a} '}
→ ]}
→ ]}

〉Греческие буквы
←%%(math outline)
←\alpha, \beta, \gamma, \lambda, \mu, \omega, \Gamma, \Lambda, \Omega
←%%
→ {type: 'root', children: [
→   {type: 'womFormatter', inline: false, format: 'math', attributes: {outline: null},
→     value: '\\alpha, \\beta, \\gamma, \\lambda, \\mu, \\omega, \\Gamma, \\Lambda, \\Omega\n'}
→ ]}

〉CSV formatter
←%%(csv delimiter=; head='1')
←Параметр;Значение;Описание;Ага!
←Пучеглазость; 0,5; Показывает степень удивления
←Красноносость; средняя; Показывает температуру за дверью;ой
←%%
→ {type: 'root', children: [{type: 'womFormatter', inline: false, format: 'csv', attributes: {delimiter: ';', head: '1'},
→   value: 'Параметр;Значение;Описание;Ага!\nПучеглазость; 0,5; Показывает степень удивления\nКрасноносость; средняя; Показывает температуру за дверью;ой\n'}]}

〉Блочный форматтер с одиним процентиком не работает
←%
←foo
←%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: '%\nfoo\n%'}]}]}
