## Форматтеры и другое на базе процентиков (formatter, markdown)

〉Форматтер не парсится
←foo %%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo %%%'}]}]}

〉foo %%x%%
←foo %%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo '}, {type: 'womFormatter', inline: true, value: 'x'}]}]}

〉foo x%%x%%
←foo x%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo x'}, {type: 'womFormatter', inline: true, value: 'x'}]}]}

〉foo \%%%x%%
←foo \%%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo '}, {type: 'text', value: '%'}, {type: 'womFormatter', inline: true, value: 'x'}]}]}

〉foo \%%x%%
←foo \%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo '}, {type: 'text', value: '%'}, {type: 'text', value: '%x%%'}]}]}

Экранирование внутри форматтеров кода не поддерживается
〉foo %%\%%%
←foo %%\%%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo '}, {type: 'womFormatter', inline: true, value: '\\%'}]}]}

Форматтер math - по сути - форматтер кода,
и так как экранирование не поддерживается внутри форматтеров,
получается что при такой записи форматтер не парсится,
потому что последний символ % опознается как часть разделителя
Поэтому для (math) есть костыль
〉foo %%(math)X\%%%
←foo %%(math)X\%%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'foo '}, {type: 'womFormatter', inline: true, format: 'math', attributes: {}, value: 'X\\%'}]}]}

〉foo %%(math)X~%%%
←foo %%(math)X~%%%
→ {type: 'root', children: [
→   {type: 'paragraph', children: [
→       {type: 'text', value: 'foo '},
→       {type: 'womFormatter', inline: true, format: 'math', attributes: {}, value: 'X~%'}
→   ]}
→ ]}

Если строчный форматтер находится в начале строки, то он не должен парситься как блочный
〉%%x%%
←%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'womFormatter', inline: true, value: 'x'}]}]}

Если строчный форматтер находится в начале строки, то он не должен парситься как блочный
〉%%(math)x%%
←%%(math)x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'womFormatter', inline: true, format: 'math', attributes: {}, value: 'x'}]}]}

〉x%%x%%
←x%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}, {type: 'womFormatter', inline: true, value: 'x'}]}]}

〉%%\nx\n%%
←%%
←x
←%%
→ {type: 'root', children: [{type: 'womFormatter', inline: false, value: 'x\n'}]}

〉%%x%%
←%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'womFormatter', inline: true, value: 'x'}]}]}

〉%%x%%\n%%x%%
←%%x%%
←%%x%%
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'womFormatter', inline: true, value: 'x'}, {type: 'text', value: '\n'}, {type: 'womFormatter', inline: true, value: 'x'}]}]}

〉%%(md)\n*test*\n%%
←%%(md)
←*test*
←%%
→{type: 'root', children: [{type:'womMarkdown', inline: false, format: 'md', attributes: {}, children: [
→   {type: 'paragraph', children: [
→       {type: 'emphasis', children: [{type: 'text', value: 'test'}]}
→   ]}
→]}]}

〉%%(md)%%
←%%(md)%%
→{type: 'root', children: [
→   {type: 'womMarkdown', inline: false, format: 'md', attributes: {}, children: []}
→]}
