const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const {
    createMdAstWomFormatterInlineNode,
    createMdAstWomFormatterBlockNode,
} = require('../lib/tokenize-skip-node/wom-formatter');
const {
    inlineWomFormatter,
    blockWomFormatter,
} = require('../utils/skip-blocks');

function womFormatter({ inline }) {
    const container = inline ?
        inlineWomFormatter :
        blockWomFormatter;
    const createMdAstWomFormatterNode = inline ?
        createMdAstWomFormatterInlineNode :
        createMdAstWomFormatterBlockNode;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomFormatterNode(this, value, now, outerNode)
        );

        return true;
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('%%', fromIndex);

    return tokenizer;
}

module.exports.womFormatter = womFormatter;
