const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const { createMdAstWomHtmlNode } = require('../lib/tokenize-skip-node/wom-html');
const {
    inlineWomHtml,
    blockWomHtml,
} = require('../utils/skip-blocks');

function womHtml({ inline }) {
    const container = inline ?
        inlineWomHtml :
        blockWomHtml;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomHtmlNode(this, value, now, outerNode)
        );

        return true;
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('<#', fromIndex);

    return tokenizer;
}

exports.womHtml = womHtml;
