// Тут одна буква X - кириллическая
const R_WOM_IMAGE_LOC = /\d+[xх]\d+:(?!file:https?:\/\/)\S+/g;
const R_WOM_IMAGE_LA0 = /^(\d+)[xх](\d+):((?!file:https?:\/\/)\S+)/;

function womImage(eat, value, silent) {
    const match = R_WOM_IMAGE_LA0.exec(value);

    if (!match) {
        return false;
    }

    if (silent) {
        return true;
    }

    const [outer, width, height, url] = match;

    eat(outer)({
        type: 'womImage',
        url,
        width: width | 0,
        height: height | 0,
    });

    return true;
}

// Locator
womImage.locator = (value, fromIndex) => {
    R_WOM_IMAGE_LOC.lastIndex = fromIndex;

    const m = R_WOM_IMAGE_LOC.exec(value);

    if (m) {
        return m.index;
    }

    return -1;
};

module.exports = womImage;
