const S_WOM_LINK_INNER = '([*#])?(\\S*?)(?:([ \\t]+)([^\\n\\r]+?))?[ \\t]*';
const S_WOM_LINK1 = `^(?:\\({2})(?!\\()${S_WOM_LINK_INNER}\\){2}`;
const S_WOM_LINK2 = `^(?:\\[{2})(?!\\[)${S_WOM_LINK_INNER}\\]{2}`;

const R_WOM_LINK1 = new RegExp(S_WOM_LINK1);
const R_WOM_LINK2 = new RegExp(S_WOM_LINK2);
const R_WOM_LINK_LOCATOR = /([([])\1+/g;

const FOOTNOTES = Object.create(null);

FOOTNOTES['*'] = 'womFootnoteReference';
FOOTNOTES['#'] = 'womFootnoteDefinition';

function womLink(eat, value, silent) {
    const match = R_WOM_LINK1.exec(value) || R_WOM_LINK2.exec(value);

    if (!match) {
        return false;
    }

    const inlineTokenizers = this.inlineTokenizers;

    // Кейс: [[test](https://ya.ru)] - [[https://ya.ru]]
    if (value[0] === '[' && inlineTokenizers.link.call(this, eat, value.slice(1), true)) {
        return false;
    }

    // Кейс: [[((https://ya.ru))]]
    // Кейс: (([[https://ya.ru]]))
    if (inlineTokenizers.womLink.call(this, eat, value.slice(2), true)) {
        return false;
    }

    if (silent) {
        return true;
    }

    let node = {};

    if (typeof match[1] === 'string') {
        node = {
            type: FOOTNOTES[match[1]],
            identifier: match[2],
            label: match[4] || null,
        };
    } else {
        const brackets = value[0] === '[';
        let children = [];

        if (match[4]) {
            const now = eat.now();
            const offset = 2 + match[2].length + match[3].length;

            now.offset += offset;
            now.column += offset;

            // Temporarily remove all tokenizers except text, womImage, womEscape in womLink
            // see https://nda.ya.ru/3Vndtw
            this.inlineTokenizers = {
                womEscape: inlineTokenizers.womEscape,
                womEscapeTilde: inlineTokenizers.womEscapeTilde,
                womImage: inlineTokenizers.womImage,
                url: inlineTokenizers.url,
                text: inlineTokenizers.text,
            };

            children = this.tokenizeInline(match[4], now);

            this.inlineTokenizers = inlineTokenizers;
        }

        node = {
            type: 'womLink',
            url: match[2],
            brackets,
            children,
        };
    }

    eat(match[0])(node);

    return true;
}

womLink.locator = (value, fromIndex) => {
    R_WOM_LINK_LOCATOR.lastIndex = fromIndex;

    if (R_WOM_LINK_LOCATOR.test(value)) {
        return R_WOM_LINK_LOCATOR.lastIndex - 2;
    }

    return -1;
};

module.exports = womLink;
