module.exports = [
    {
        group: 'womLink',
        tests: [
            {
                markup: '[[Ya](https://ya.ru)]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'link', title: null, url: 'https://ya.ru', children: [
                            { type: 'text', value: 'Ya' },
                        ] },
                        { type: 'text', value: ']' },
                    ] },
                ] },
            },
            {
                markup: '[[[https://ya.ru Ya]]]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'womLink', url: 'https://ya.ru', brackets: true, children: [
                            { type: 'text', value: 'Ya' },
                        ] },
                        { type: 'text', value: ']' },
                    ] },
                ] },
            },
            {
                markup: '[[[[https://ya.ru Ya]]]]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[[' },
                        { type: 'womLink', url: 'https://ya.ru', brackets: true, children: [
                            { type: 'text', value: 'Ya' },
                        ] },
                        { type: 'text', value: ']]' },
                    ] },
                ] },
            },
            {
                markup: '[((https://ya.ru Ya))]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'linkReference', identifier: '((https://ya.ru ya))', label: '((https://ya.ru Ya))', referenceType: 'shortcut', children: [
                            { type: 'womLink', url: 'https://ya.ru', brackets: false, children: [
                                { type: 'text', value: 'Ya' },
                            ] },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '[[((https://ya.ru Ya))]]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'linkReference', identifier: '((https://ya.ru ya))', label: '((https://ya.ru Ya))', referenceType: 'shortcut', children: [
                            { type: 'womLink', url: 'https://ya.ru', brackets: false, children: [
                                { type: 'text', value: 'Ya' },
                            ] },
                        ] },
                        { type: 'text', value: ']' },
                    ] },
                ] },
            },
            {
                markup: '[[test](https://foo.bar)]\n[[https://ya.ru test]]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'link', title: null, url: 'https://foo.bar', children: [
                            { type: 'text', value: 'test' },
                        ] },
                        { type: 'text', value: ']\n' },
                        { type: 'womLink', url: 'https://ya.ru', brackets: true, children: [
                            { type: 'text', value: 'test' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '[[test](https://foo.bar)] [[https://ya.ru test]]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'link', title: null, url: 'https://foo.bar', children: [
                            { type: 'text', value: 'test' },
                        ] },
                        { type: 'text', value: '] ' },
                        { type: 'womLink', url: 'https://ya.ru', brackets: true, children: [
                            { type: 'text', value: 'test' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: '[[test](https://foo.bar)]\n[[((https://ya.ru test))]]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'link', title: null, url: 'https://foo.bar', children: [
                            { type: 'text', value: 'test' },
                        ] },
                        { type: 'text', value: ']\n[' },
                        { type: 'linkReference', identifier: '((https://ya.ru test))', label: '((https://ya.ru test))', referenceType: 'shortcut', children: [
                            { type: 'womLink', url: 'https://ya.ru', brackets: false, children: [
                                { type: 'text', value: 'test' },
                            ] },
                        ] },
                        { type: 'text', value: ']' },
                    ] },
                ] },
            },
            {
                markup: '[[test](https://foo.bar)]\n(([[https://ya.ru test]]))',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '[' },
                        { type: 'link', title: null, url: 'https://foo.bar', children: [
                            { type: 'text', value: 'test' },
                        ] },
                        { type: 'text', value: ']\n((' },
                        { type: 'womLink', url: 'https://ya.ru', brackets: true, children: [
                            { type: 'text', value: 'test' },
                        ] },
                        { type: 'text', value: '))' },
                    ] },
                ] },
            },
            {

                markup: 'inline <a >\n\n((https://ya.ru))\n',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'inline ' },
                        { type: 'html', value: '<a >' },

                    ] },
                    { type: 'paragraph', children: [
                        { type: 'womLink', url: 'https://ya.ru', brackets: false, children: [] },
                    ] },
                ] },
            },
            {
                markup: '((https://ya.ru Ya\n))',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: '((' },
                        { type: 'link', title: null, url: 'https://ya.ru', children: [
                            { type: 'text', value: 'https://ya.ru' },
                        ] },
                        { type: 'text', value: ' Ya\n))' },
                    ] },
                ] },
            },
            {
                markup: '((https://st.yandex-team.ru/EXPERIMENTS-45315 Отключение редиров на десктопах\u2028))',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'womLink', url: 'https://st.yandex-team.ru/EXPERIMENTS-45315', brackets: false, children: [
                            { type: 'text', value: 'Отключение редиров на десктопах\u2028' },
                        ] }
                    ] },
                ] },
            },
        ],
    },
];
