/* eslint-disable */

var decimal = require('is-decimal');
var getIndent = require('remark-parse/lib/util/get-indentation');
var removeIndent = require('remark-parse/lib/util/remove-indentation');
const { createMdAstNode } = require('../lib/tokenize-skip-node');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');

const {
    parseAnyContainerAt,
    findLineEndBetween,
} = require('../utils/parse-container-utils');
const {
    blocks,
    inlines,
} = require('../utils/skip-blocks');

var C_ASTERISK = '*';
var C_UNDERSCORE = '_';
var C_PLUS = '+';
var C_DASH = '-';
var C_DOT = '.';
var C_SPACE = ' ';
var C_NEWLINE = '\n';
var C_TAB = '\t';
var C_PAREN_CLOSE = ')';
var C_X_LOWER = 'x';
var C_EMPTY = '';

var TAB_SIZE = 4;
var EXPRESSION_LOOSE_LIST_ITEM = /\n\n(?!\s*$)/;
var EXPRESSION_TASK_ITEM = /^\[([ \t]|x|X|)][ \t]/;
var EXPRESSION_WOM_BULLET = /^([ \t]*)((?:[*+-]|[A-Za-z\d]+[.)])(?:[#№]\d+)?\+?)( {1,4}(?! )| |\t|$|(?=\n))([^\n]*)/;
var EXPRESSION_AFTER_BULLET = /^(\+)?([^\n]+)?(\n[ \t]*[*+\d-])?/;
var EXPRESSION_GAP_BULLET = /^[#№](\d+)/;

/* Map of characters which can be used to mark
 * list-items. */
var LIST_UNORDERED_MARKERS = {};

LIST_UNORDERED_MARKERS[C_ASTERISK] = true;
LIST_UNORDERED_MARKERS[C_PLUS] = true;
LIST_UNORDERED_MARKERS[C_DASH] = true;

/* Map of characters which can be used to mark
 * list-items after a digit. */
var LIST_ORDERED_COMMONMARK_MARKERS = {};

LIST_ORDERED_COMMONMARK_MARKERS[C_DOT] = true;
LIST_ORDERED_COMMONMARK_MARKERS[C_PAREN_CLOSE] = true;

function list(eat, value, silent) {
    var self = this;
    var tokenizers = self.blockTokenizers;
    var interuptors = self.interruptList;
    var index = 0;
    var length = value.length;
    var start = null;
    var size = 0;
    var queue;
    var ordered;
    var styleType;
    var character;
    var marker;
    var nextIndex;
    var startIndex;
    var prefixed;
    var currentMarker;
    var line;
    var prevEmpty;
    var empty;
    var items;
    var emptyLines;
    var item;
    var enterTop;
    var exitBlockquote;
    var isLoose;
    var node;
    var now;
    var end;
    var indented;
    var expandable;
    var restart;
    let breakingNode = null;
    let breakingNodeAt = -1;
    let outerFirstIndex = 0;

    // Считаем начальную индентацию
    while (index < length) {
        character = value.charAt(index);

        if (character === C_TAB) {
            size += TAB_SIZE - (size % TAB_SIZE);
        } else if (character === C_SPACE) {
            size++;
        } else {
            break;
        }

        index++;
    }

    if (size >= TAB_SIZE) {
        // Невалидный список, индентация должна быть МЕНЬШЕ TAB_SIZE
        return;
    }

    // Предполааем что первый непробельный символ - маркер элемента списка
    character = value.charAt(index);

    if (LIST_UNORDERED_MARKERS[character] === true) {
        // Символ является маркером
        marker = character;
        // Список НЕ является нумерованным
        ordered = false;
    } else {
        // Иначе, почему-то список считается нумерованным
        ordered = true;
        // В эту переменную собираем все циферные символы
        queue = '';

        while (index < length) {
            character = value.charAt(index);

            if (!decimal(character)) {
                break;
            }

            queue += character;
            index++;
        }

        // Определяем тип нумерованного списка
        if (queue) {
            styleType = 'decimal';
        } else if (character === 'i') {
            styleType = 'lower-roman';
            queue += character;
            index++;
        } else if (character === 'I') {
            styleType = 'upper-roman';
            queue += character;
            index++;
        } else if (/[a-z]/.test(character)) {
            styleType = 'lower-alpha';
            queue += character;
            index++;
        } else if (/[A-Z]/.test(character)) {
            styleType = 'upper-alpha';
            queue += character;
            index++;
        }

        character = value.charAt(index);

        if (!queue || LIST_ORDERED_COMMONMARK_MARKERS[character] !== true) {
            // Невалидный разделитель нумерованного списка
            return;
        }

        // В зависимости от типа нумерованного списка
        // определеяем номер первого пункта списка
        if (styleType === 'decimal') {
            start = parseInt(queue, 10);
        }

        if (styleType === 'lower-alpha') {
            start = queue.charCodeAt(0) - 'a'.charCodeAt(0) + 1;
        }

        if (styleType === 'upper-alpha') {
            start = queue.charCodeAt(0) - 'A'.charCodeAt(0) + 1;
        }

        if (styleType === 'upper-roman' || styleType === 'lower-roman') {
            start = 1;
        }

        marker = character;
    }

    index++;

    //1.#8
    var gapBullet = value.slice(index).match(EXPRESSION_GAP_BULLET);

    if (ordered && gapBullet) {
        index += gapBullet[0].length;
    }

    character = value.charAt(index);

    //1.+
    if (character === C_PLUS) {
        index++;
    }

    character = value.charAt(index);

    if (
        character !== C_SPACE &&
        character !== C_TAB &&
        (character !== C_NEWLINE && character !== C_EMPTY)
    ) {
        // Невалидный пункт списка,
        // потому что после разделителя не идет пробельный символ
        return;
    }

    // Одиноко стоящие некоторые маркеры списков не являются пустыми списками
    var signsAloneMatch = value.slice(index).match(EXPRESSION_AFTER_BULLET);
    if (!signsAloneMatch
        || (!signsAloneMatch[1]
            && !(signsAloneMatch[2] && signsAloneMatch[2].trim())
            && !(signsAloneMatch[3] && signsAloneMatch[3].trim()))
    ) {
        return;
    }

    // Список уже считается валидным,
    // как минимум один валидный пункт уже есть
    if (silent) {
        // В режиме silent выходим
        return true;
    }

    index = 0;
    items = [];
    emptyLines = [];

    // Тут идет сбор строк, пустых и не пустых, строки содержат индентацию
    outer: while (index < length) {
        // Высчитываем конец строки
        nextIndex = findLineEndBetween(inlines, value, index, length);
        startIndex = index;
        prefixed = false;
        indented = false;
        expandable = false;
        restart = null;

        if (nextIndex === -1) {
            nextIndex = length;
        }

        // В end лежит размер разделителя до контента
        end = index + TAB_SIZE;
        // size - Это размер индентации текущего списка
        size = 0;

        // Снова считаем размер отступа
        while (index < length) {
            character = value.charAt(index);

            if (character === C_TAB) {
                size += TAB_SIZE - (size % TAB_SIZE);
            } else if (character === C_SPACE) {
                size++;
            } else {
                break;
            }

            index++;
        }

        if (size >= TAB_SIZE) {
            // Отступ не меньше базового,
            // значит строка с отступом
            indented = true;
        }

        if (item && size >= item.indent) {
            // Если это не первая строка item-а
            // и текущий отступ не меньше отступа этого пункта,
            // То эта строка тоже с отступом
            indented = true;
        }

        // Смотрим первый символ
        character = value.charAt(index);
        currentMarker = null;

        if (!indented) {
            if (LIST_UNORDERED_MARKERS[character] === true) {
                // Ненумерованный список
                currentMarker = character;
                index++;
                size++;
            } else {
                // Нумерованный список
                queue = '';

                // Собираем циферные символы
                while (index < length) {
                    character = value.charAt(index);

                    if (!decimal(character)) {
                        break;
                    }

                    queue += character;
                    index++;
                }

                if (!queue && /[a-zA-Z]/.test(character)) {
                    // Не нашли циферные символы, но нашли буквенные
                    queue += character;
                    index++;
                }

                character = value.charAt(index);
                index++;

                if (queue && LIST_ORDERED_COMMONMARK_MARKERS[character] === true) {
                    currentMarker = character;
                    size += queue.length + 1;
                }
            }

            if (currentMarker) {
                // Нашли маркер, проверяем, есть ли явное указание номера пункта списка
                gapBullet = value.slice(index).match(EXPRESSION_GAP_BULLET);

                if (LIST_ORDERED_COMMONMARK_MARKERS[currentMarker] && gapBullet) {
                    // Если это нумерованный список и в пункте
                    // есть указание номера текущего пункта, то парсим его
                    restart = parseInt(gapBullet[1], 10);
                    index += gapBullet[0].length;
                    size += gapBullet[0].length;
                }

                character = value.charAt(index);

                if (character === C_PLUS) {
                    // Нашли кат, отмечаем что этот пунт может схлопываться
                    expandable = true;
                    index++;
                    size++;

                    character = value.charAt(index);
                }

                if (character === C_TAB) {
                    // Если следующий символ - табуляция
                    // То добавляем к общей индентации такой спейсинк,
                    // чтобы сделать отступ кратный размеру табуляции
                    size += TAB_SIZE - (size % TAB_SIZE);
                    index++;
                } else if (character === C_SPACE) {
                    end = index + TAB_SIZE;

                    // Если следующий символ - пробел, отъедаем пробелы
                    while (index < end) {
                        if (value.charAt(index) !== C_SPACE) {
                            break;
                        }

                        index++;
                        size++;
                    }

                    if (index === end && value.charAt(index) === C_SPACE) {
                        index -= TAB_SIZE - 1;
                        size -= TAB_SIZE - 1;
                    }
                } else if (character !== C_NEWLINE && character !== '') {
                    currentMarker = null;
                }
            }
        }

        if (currentMarker) {
            //  Найден маркер пункта
            if (marker !== currentMarker) {
                // Если маркер не равен базовому маркеру,
                // То пуннкт не валиден
                break;
            }

            // Отмечаем, что у этой линии есть префикс
            prefixed = true;
        } else {
            // Маркер не найден, значит это продолжение предыдущего пункта
            if (item) {
                // Линия с отступом, если отступ не меньше базового
                indented = size >= item.indent || size > TAB_SIZE;
            }

            // Отмечаем, что эта линия не открывает пункт
            prefixed = false;
            index = startIndex;
        }

        // Получаем строку. Именно тут мы окончательно определились со строкой
        line = value.slice(startIndex, nextIndex);

        // Некоторые пункты списка могут быть похожи на thematicBreak
        // * ***
        // Это не валидный пункт списка, а обрыв списка
        if (
            (
                currentMarker === C_ASTERISK ||
                currentMarker === C_UNDERSCORE ||
                currentMarker === C_DASH
            ) &&
            tokenizers.thematicBreak.call(self, eat, line, true)
        ) {
            // Перестаем собирать линии
            break;
        }

        // Определяем флаг пустости пункта списка,
        // предварительно сохранив информацию о предыдущем списке
        prevEmpty = empty;
        empty = value.slice(index, nextIndex).trim() === '';

        if (indented && item) {
            // Линия с отступом и предыдущий пункт уже определен
            // Добавляем к пункту пустые линии и текущую линию
            item.value = item.value.concat(emptyLines, line);
            outerFirstIndex = nextIndex;
            emptyLines = [];
        } else if (prefixed) {
            // Если это префиксованная строка,
            // то item точно определен если есть пустые строки
            if (emptyLines.length > 0) {
                item.value.push('');
                // Клонируем пустые строки в trail
                item.trail = emptyLines.concat();
            }

            // Определяем новый item
            item = {
                value: [line],
                indent: size,
                trail: [],
                expandable,
                restart,
            };

            outerFirstIndex = nextIndex;

            // Добавляем item в нужный список
            items.push(item);
            emptyLines = [];
        } else if (prevEmpty) {
            // Если предыдущая строка была пустая, то это разрыв списка
            break;
        } else if (empty) {
            // Сохраняем пустую линию
            emptyLines.push(line);
        } else {
            // Эта строка – без отступа и не открывает пункт списка
            // Далее идет проверка на разрыв списка блоком
            // Пробуем распарсить контейнер
            breakingNodeAt = startIndex + size;
            breakingNode = parseAnyContainerAt(blocks, value, breakingNodeAt);

            if (breakingNode) {
                // Распарсили блок, разрываем список
                break;
            }

            // Если не распарсили нашим механизмом, значит,
            // либо мы еще не умеем парсить какие-то контейнеры,
            // либо просто действительно нечего распарсить.
            // Поэтому проверяем также встроенным механизмом
            for (let i = 0; i < interuptors.length; i += 1) {
                const [name] = interuptors[i];

                if (tokenizers[name].call(this, eat, line, true)) {
                    break outer;
                }
            }

            // Сохраняем пустые строки и идем на
            // следующий цикл если не было разрыва списка
            item.value = item.value.concat(emptyLines, line);
            outerFirstIndex = nextIndex;
            emptyLines = [];
        }

        index = nextIndex + 1;
    }

    node = eat(value.slice(0, outerFirstIndex)).reset({
        type: 'list',
        ordered: ordered,
        styleType: styleType,
        start: start,
        loose: null,
        children: [],
    });

    enterTop = self.enterList();
    exitBlockquote = self.enterBlock();
    isLoose = false;
    index = -1;
    length = items.length;

    while (++index < length) {
        item = items[index];

        item.string = item.value.join(C_NEWLINE);
        now = eat.now();

        item = eat(item.string)(listItem(self, item, now), node);

        if (item.loose) {
            isLoose = true;
        }

        item = items[index].trail.join(C_NEWLINE);

        if (index !== length - 1) {
            item += C_NEWLINE;
        }

        eat(item);
    }

    enterTop();
    exitBlockquote();

    node.loose = isLoose;

    if (breakingNode) {
        eat(value.slice(outerFirstIndex, breakingNodeAt));
        const now = eat.now();

        eat(getNodeOuterText(value, breakingNode))(
            createMdAstNode(this, value, now, breakingNode)
        );
    }

    return true;
}

function listItem(ctx, item, position) {
    var offsets = ctx.offset;
    var checked = null;
    var task;
    var indent;
    var title = null;

    var value = normalListItem(ctx, item.string, position);

    task = value.match(EXPRESSION_TASK_ITEM);

    if (task) {
        indent = task[0].length;
        checked = task[1].toLowerCase() === C_X_LOWER;
        offsets[position.line] += indent;
        value = value.slice(indent);
    }

    if (item.expandable) {
        let newLineIndex = value.indexOf(C_NEWLINE);
        if (newLineIndex === -1) {
            newLineIndex = value.length;
        }
        title = value.slice(0, newLineIndex);
        value = value.slice(newLineIndex + 1);
        item.title = ctx.tokenizeInline(title, position);

        if (value) {
            position.line++;
            position.column = 1;
        }
    }

    return {
        type: 'listItem',
        loose: EXPRESSION_LOOSE_LIST_ITEM.test(value) ||
            value.charAt(value.length - 1) === C_NEWLINE,
        checked: checked,
        expandable: item.expandable,
        title: item.title,
        restart: item.restart,
        children: ctx.tokenizeBlock(value, position),
    };
}

/* Create a list-item using sane mechanics. */
function normalListItem(ctx, value, position) {
    var offsets = ctx.offset;
    var line = position.line;
    var max;
    var bullet;
    var rest;
    var lines;
    var trimmedLines;
    var index;
    var length;

    /* Remove the list-item’s bullet. */
    value = value.replace(EXPRESSION_WOM_BULLET, replacer);
    lines = value.split(C_NEWLINE);

    trimmedLines = removeIndent(value, getIndent(max).indent).split(C_NEWLINE);

    /* We replaced the initial bullet with something
     * else above, which was used to trick
     * `removeIndentation` into removing some more
     * characters when possible.  However, that could
     * result in the initial line to be stripped more
     * than it should be. */
    trimmedLines[0] = rest;

    offsets[line] = (offsets[line] || 0) + bullet.length;
    line++;

    index = 0;
    length = lines.length;

    while (++index < length) {
        offsets[line] = (offsets[line] || 0) +
            lines[index].length - trimmedLines[index].length;
        line++;
    }

    return trimmedLines.join(C_NEWLINE);

    function replacer($0, $1, $2, $3, $4) {
        bullet = $1 + $2 + $3;
        rest = $4;

        /* Make sure that the first nine numbered list items
         * can indent with an extra space.  That is, when
         * the bullet did not receive an extra final space. */
        if (Number($2) < 10 && bullet.length % 2 === 1) {
            $2 = C_SPACE + $2;
        }

        max = $1 + C_SPACE.repeat($2.length) + $3;

        return max + rest;
    }
}

module.exports = list;
