const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const {
    createMdAstWomMarkdownInlineNode,
    createMdAstWomMarkdownBlockNode,
} = require('../lib/tokenize-skip-node/wom-markdown');
const {
    inlineWomMarkdown,
    blockWomMarkdown,
} = require('../utils/skip-blocks');

function womMarkdown({ inline }) {
    const container = inline ?
        inlineWomMarkdown :
        blockWomMarkdown;
    const createMdAstWomMarkdownNode = inline ?
        createMdAstWomMarkdownInlineNode :
        createMdAstWomMarkdownBlockNode;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomMarkdownNode(this, value, now, outerNode)
        );

        return true;
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('%%', fromIndex);

    return tokenizer;
}

module.exports.womMarkdown = womMarkdown;
