const {
    parseAnyContainerAt,
    findLineEndBetween,
} = require('../utils/parse-container-utils');
const {
    skipLineFollowingSpacing,
    getNodeOuterText,
} = require('../utils/skip-blocks-utils');
const {
    blocks,
    inlines,
} = require('../utils/skip-blocks');
const { createMdAstNode } = require('../lib/tokenize-skip-node');
const { shiftLocation } = require('../lib/tokenize-skip-node/utils');

function paragraph(eat, value) {
    const blockTokenizers = this.blockTokenizers;
    const interruptParagraph = this.interruptParagraph;
    const length = value.length;
    let index = 0;
    let breakingNode = null;

    const interruptersLength = interruptParagraph.length;

    outer: while (index < length) {
        index = findLineEndBetween(inlines, value, index, length);

        // Если перенос строки не найден, то доедаем все до конца
        if (index === -1) {
            index = length;
            break;
        }

        index += 1;

        // Если дальше идет пустая строка, то параграф разорван
        if (skipLineFollowingSpacing(value, index) > -1) {
            break;
        }

        // Ищем разрыв параграфа
        breakingNode = parseAnyContainerAt(blocks, value, index);

        if (breakingNode) {
            //  Распарсили блок во время парсинга параграфа, разрываем параграф
            break;
        }

        // Если сами не смогли разорвать,
        // то используем встроенный механизм, который поддерживает те блоки,
        // которые мы еще не умеем парсить

        const subvalue = value.slice(index);

        for (let i = 0; i < interruptersLength; i += 1) {
            const [name] = interruptParagraph[i];

            if (blockTokenizers[name].call(this, eat, subvalue, true)) {
                break outer;
            }
        }
    }

    let now = eat.now();
    const outer = value.slice(0, index);

    let inner = outer;

    inner = inner.trimLeft();

    shiftLocation(now, outer, 0, outer.length - inner.length);

    inner = inner.trimRight();

    eat(outer)({
        type: 'paragraph',
        children: this.tokenizeInline(inner, now),
    });

    if (breakingNode) {
        now = eat.now();

        eat(getNodeOuterText(value, breakingNode))(
            createMdAstNode(this, value, now, breakingNode)
        );
    }

    return true;
}

module.exports = paragraph;
