const {
    findTailIndex,
    checkLeftFlankingDelimiterRunBounds,
} = require('../utils/spec');
const { makeColor } = require('../utils/make-color');

function womRemark(eat, value, silent) {
    const headMatch = /^(!!(?:\(((?:\\[\s\S]|[^()])+)\))?)[^!]/.exec(value);

    if (!headMatch) {
        return false;
    }

    const openingInitialIndex = headMatch.index;

    if (openingInitialIndex > 0) {
        return false;
    }

    const fullMatch = headMatch[1];
    const innerFirstIndex = openingInitialIndex + fullMatch.length;

    if (!checkLeftFlankingDelimiterRunBounds(value, openingInitialIndex, innerFirstIndex, false)) {
        return false;
    }

    const closingInitialIndex = findTailIndex(value, innerFirstIndex, '!', 2, false);

    if (closingInitialIndex < 0) {
        return false;
    }

    if (silent) {
        return true;
    }

    const props = {};
    const specMatch = headMatch[2];

    if (specMatch) {
        props.color = makeColor(specMatch.replace(/\\([\s\S])/, '$1'));
    } else {
        props.color = makeColor(null);
    }

    const inner = value.slice(innerFirstIndex, closingInitialIndex);
    const outer = value.slice(0, closingInitialIndex + 2); // 2 === '!!'.length

    const now = eat.now();

    now.column += innerFirstIndex;
    now.offset += innerFirstIndex;

    eat(outer)({
        type: 'womRemark',
        children: this.tokenizeInline(inner, now),
        ...props,
    });
}

womRemark.locator = (value, fromIndex) =>
    value.indexOf('!!', fromIndex);

module.exports = womRemark;
