## Таблицы и раскладки (table)

〉Таблица с пробелами и переносами строк в ячейке
←#| ||
←ячейка_1_1
←|
← \\n   ячейка_1_2  \\n  \\nячейка_1_3
←ячейка_1_4
←  \\n
←|| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'ячейка_1_1'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [
→       {type: 'text', value: '\\'},
→       {type: 'text', value: 'n   ячейка_1_2  '},
→       {type: 'text', value: '\\'},
→       {type: 'text', value: 'n  '},
→       {type: 'text', value: '\\'},
→       {type: 'text', value: 'nячейка_1_3\nячейка_1_4\n  '},
→       {type: 'text', value: '\\'},
→       {type: 'text', value: 'n'},
→     ]}]}
→   ]}
→ ]}
→ ]}
→ ]}

〉Таблица с пробелами и переносами строк
←#||||\\xa0||||#
←#|\\xa0||cell1\\u2006
←\\u2002row2||\\u3000|#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, kind: 'layout', children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [
→         {type: 'text', value: '\\'},
→         {type: 'text', value: 'xa0'},
→       ]}]}
→     ]}
→   ]},
→   {type: 'text', value: '\n'},
→   {type: 'womTable', inline: true, children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [
→         {type: 'text', value: 'cell1'},
→         {type: 'text', value: '\\'},
→         {type: 'text', value: 'u2006\n'},
→         {type: 'text', value: '\\'},
→         {type: 'text', value: 'u2002row2'},
→       ]}]}
→     ]}
→   ]},
→ ]}
→ ]}

〉Табличка, внутри ячейки которой есть разделители таблицы (escape "")
←#|
←||foo ""|"" bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo '
→                 },
→                 {
→                   type: 'womEscape',
→                   raw: '""|""',
→                   value: '|'
→                 },
→                 {
→                   type: 'text',
→                   value: ' bar'
→                 }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка, внутри ячейки которой есть разделители таблицы (escape ~)
←#|
←||foo ~| bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo '
→                 },
→                 {
→                   type: 'womEscape',
→                   raw: '~|',
→                   value: '|'
→                 },
→                 {
→                   type: 'text',
→                   value: ' bar'
→                 }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка, внутри ячейки которой есть разделитель таблицы (escape \)
←#|
←||foo \| bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo '
→                 },
→                 {
→                   type: 'text',
→                   value: '|'
→                 },
→                 {
→                   type: 'text',
→                   value: ' bar'
→                 },
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка, внутри ячейки которой есть разделитель таблицы (\\)
←#|
←||foo \\| bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo '
→                 },
→                 {
→                   type: 'text',
→                   value: '\\'
→                 },
→               ]
→             }
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'bar'
→                 },
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка со строчным форматтером, внутри ячейки которой есть разделитель таблицы (escape \)
←#|
←||!!foo \| bar!!||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womRemark',
→                       color: {type: 'color', value: '@red', raw: null},
→                       children: [
→                           {
→                               type: 'text',
→                               value: 'foo '
→                           },
→                           {
→                               type: 'text',
→                               value: '|'
→                           },
→                           {
→                               type: 'text',
→                               value: ' bar'
→                           },
→                       ]
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка со строчным форматтером, внутри ячейки которой есть разделитель таблицы (\\)
←#|
←||!!foo \\| bar!!||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: '!!foo '
→                 },
→                 {
→                   type: 'text',
→                   value: '\\'
→                 },
→               ]
→             }
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'bar!!'
→                 },
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Минимальная табличка без ничего
←#|
←||foo||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo'
→                 },
→               ]
→             }
→           ]
→         },
→       ]
→     }
→   ]
→}
→]}

〉Табличка, внутри ячейки которой есть якобы открытое блочное экранирование (escape)
←#|
←||foo\""bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo',
→                 },
→                 {
→                   type: 'text',
→                   value: '"',
→                 },
→                 {
→                   type: 'text',
→                   value: '"bar',
→                 },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉Табличка, внутри ячейки которой есть открытое блочное экранирование
←#|
←||foo""bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'foo""bar',
→                 },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉Табличка, внутри ячейки которой есть закрытое и открытое блочное экранирование
←#|
←||f""o""o""bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'text',
→                   value: 'f',
→                 },
→                 {
→                   type: 'womEscape',
→                   raw: '""o""',
→                   value: 'o',
→                 },
→                 {
→                   type: 'text',
→                   value: 'o""bar',
→                 },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉Табличка со строчным wom-форматтером кода, в котором есть разделитель
←#|
←||%%foo | bar%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: 'foo | bar',
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка с блочным wom-форматтером кода, в котором есть разделитель
←#|
←||
←%%
←foo | bar
←%%
←||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'womFormatter',
→                   inline: false,
→                   value: 'foo | bar\n',
→               },
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка внутри которой есть незакрытый wom-форматер кода
←#|
←||%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'text',
→                       value: '%%',
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка со строчным md-форматтером кода, в котором есть разделитель
←#|
←||`foo | bar`||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'inlineCode',
→                       value: 'foo | bar',
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка с блочным md-форматтером кода, в котором есть разделитель
←#|
←||
←```
←foo | bar
←```
←||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'code',
→                   lang: null,
→                   meta: null,
→                   value: 'foo | bar',
→               },
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка со странным строчным md-форматтером кода, в котором есть разделители
←#|
←||`foo `` | `` bar`||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'inlineCode',
→                       value: 'foo `` | `` bar',
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка внутри которой есть не закрытый md-форматер кода
←#|
←||`||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'text',
→                       value: '`',
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Табличка внутри которой есть ПУСТОЙ md-форматер кода
Фишка MD форматтеров в том, что они могут быть пустыми и их невозможно не закрыть
разделители строчников состоят из лббого количества символов > 0
блочники могут быть закрыты бОльшим количеством символов, чем были открыты
Поэтому этот тест просто показыват что ничего не ломается
←#|
←||``||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'inlineCode',
→                       value: '',
→                   }
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Пересекающиеся форматтеры %%```%%```
←#|
←||
←%%
←foo```bar
←%%
←```
←||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'womFormatter',
→                   inline: false,
→                   value: 'foo```bar\n',
→               },
→               {
→                   type: 'code',
→                   lang: null,
→                   meta: null,
→                   value: '',
→               },
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Пересекающиеся форматтеры ```%%```%%
←#|
←||
←```
←foo%%bar
←```
←%%
←||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'code',
→                   lang: null,
→                   meta: null,
→                   value: 'foo%%bar',
→               },
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: '%%',
→                       },
→                   ]
→               }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Пример из жизни 1
←#|
←|| удалить все локальные образы | %%docker images -aq | xargs docker rmi -f%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: 'удалить все локальные образы',
→                       },
→                   ]
→               },
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'womFormatter',
→                           inline: true,
→                           value: 'docker images -aq | xargs docker rmi -f',
→                       },
→                   ]
→               },
→           ]
→         }
→       ]
→     },
→   ]
→}
→]}

〉Пример из жизни 2 (несколько форматтеров)
←#|
←|| удалить все локальные образы | %%docker images -aq | xargs docker rmi -f%%||
←|| удалить все локальные образы | %%docker images -aq | xargs docker rmi -f%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: 'удалить все локальные образы',
→                       },
→                   ]
→               },
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'womFormatter',
→                           inline: true,
→                           value: 'docker images -aq | xargs docker rmi -f',
→                       },
→                   ]
→               },
→           ]
→         }
→       ]
→     },
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: 'удалить все локальные образы',
→                       },
→                   ]
→               },
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'womFormatter',
→                           inline: true,
→                           value: 'docker images -aq | xargs docker rmi -f',
→                       },
→                   ]
→               },
→           ]
→         }
→       ]
→     },
→   ]
→}
→]}

〉Пример из жизни 3
←#|
←|| удалить все локальные образы | %%docker images -aq | xargs docker rmi -f%%||
←|| удалить все локальные образы | %%docker images -aq | xargs docker rmi -f%%||
←|| удалить все локальные образы | %%docker images -aq | xargs docker rmi -f%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: 'удалить все локальные образы',
→                       },
→                   ]
→               },
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'womFormatter',
→                           inline: true,
→                           value: 'docker images -aq | xargs docker rmi -f',
→                       },
→                   ]
→               },
→           ]
→         }
→       ]
→     },
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: 'удалить все локальные образы',
→                       },
→                   ]
→               },
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'womFormatter',
→                           inline: true,
→                           value: 'docker images -aq | xargs docker rmi -f',
→                       },
→                   ]
→               },
→           ]
→         }
→       ]
→     },
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'text',
→                           value: 'удалить все локальные образы',
→                       },
→                   ]
→               },
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→               {
→                   type: 'paragraph',
→                   children: [
→                       {
→                           type: 'womFormatter',
→                           inline: true,
→                           value: 'docker images -aq | xargs docker rmi -f',
→                       },
→                   ]
→               },
→           ]
→         }
→       ]
→     },
→   ]
→}
→]}
〉Пример из жизни 4
←#|
←||%%% %% test %% %%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '% ',
→                   },
→                   {type: 'text', value: ' test '},
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: ' %',
→                   },
→               ]
→             }
→           ]
→         }
→       ]
→     }
→   ]
→}
→]}

〉Приммер из жизни 5
←#|
←||%%% %% test %% %%%||
←||%%% %% test %% %%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '% ',
→                   },
→                   {type: 'text', value: ' test '},
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: ' %',
→                   },
→               ]
→             }
→           ]
→         },
→       ]
→     },
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '% ',
→                   },
→                   {type: 'text', value: ' test '},
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: ' %',
→                   },
→               ]
→             }
→           ]
→         },
→       ]
→     }
→   ]
→}
→]}


〉Приммер из жизни 6
←#|
←||%%% %% test %% %%%||
←||%%% %% test %% %%%||
←||%%% %% test %% %%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '% ',
→                   },
→                   {type: 'text', value: ' test '},
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: ' %',
→                   },
→               ]
→             }
→           ]
→         },
→       ]
→     },
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '% ',
→                   },
→                   {type: 'text', value: ' test '},
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: ' %',
→                   },
→               ]
→             }
→           ]
→         },
→       ]
→     },
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '% ',
→                   },
→                   {type: 'text', value: ' test '},
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: ' %',
→                   },
→               ]
→             }
→           ]
→         },
→       ]
→     },
→   ]
→}
→]}

〉Заэкранированный форматтер в таблице
←#|
←||""%%test%%""||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                 {
→                   type: 'womEscape',
→                   raw: '""%%test%%""',
→                   value: '%%test%%',
→                 },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉Табличка без форматеров, но с процентами
←#|
←||% foo %|bar||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'text',
→                       value: '% foo %',
→                   }
→               ]
→             }
→           ]
→         },
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'text',
→                       value: 'bar',
→                   }
→               ]
→             }
→           ]
→         },
→       ]
→     }
→   ]
→}
→]}

〉Кусок из жизни
←#|
←||%D0%B0%|%%docker images -aq |xargs docker rmi -f%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'text',
→                       value: '%D0%B0%',
→                   },
→               ],
→             },
→           ],
→         },
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: 'docker images -aq |xargs docker rmi -f',
→                   },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉\ не должен экранировать закрывающий разделитель md форматтера
←#|
←||`\`|`test`||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'inlineCode',
→                       value: '\\',
→                   },
→               ],
→             },
→           ],
→         },
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'inlineCode',
→                       value: 'test',
→                   },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉\ не должен экранировать закрывающий разделитель wom форматтера
←#|
←||%%\%%|%%test%%||
←|#
→{type: 'root', children: [
→{
→   type: 'womTable', inline: false,
→   children: [
→     {
→       type: 'womTableRow',
→       children: [
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: '\\',
→                   },
→               ],
→             },
→           ],
→         },
→         {
→           type: 'womTableCell',
→           children: [
→             {
→               type: 'paragraph',
→               children: [
→                   {
→                       type: 'womFormatter',
→                       inline: true,
→                       value: 'test',
→                   },
→               ],
→             },
→           ],
→         },
→       ],
→     },
→   ],
→},
→]}

〉Однострочная таблица
←#| ||cell11|| ||cell21|| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell11'}]}]}
→     ]},
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell21'}]}]}
→     ]}
→   ]}
→ ]}
→ ]}

〉Таблица из разметки
←#|
←||cell11|cell12|cell13||
←||cell21|cell22||
←|#
→ {type: 'root', children: [
→   {type: 'womTable', inline: false, children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell11'}]}]},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell12'}]}]},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell13'}]}]}
→     ]},
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell21'}]}]},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell22'}]}]},
→     ]}
→   ]}
→ ]}

〉Однострочная раскладка
←#|| ||cell11|| ||cell21|| ||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, kind: 'layout', children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell11'}]}]}
→     ]},
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell21'}]}]}
→     ]}
→   ]}
→ ]}
→ ]}

〉Вложенная таблица
←#| || 1 | #| || xxx || |# | 1 | #| || xxx || |# | 1 || |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, children: [
→       {type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: '1'}]} 
→           ]},
→           {type: 'womTableCell', children: [
→           {type: 'paragraph', children: [
→               {type: 'womTable', inline: true, children: [
→                   {type: 'womTableRow', children: [
→                       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'xxx'}]}]}
→                   ]} 
→               ]},
→           ]},
→           ]},
→           {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: '1'}]} 
→           ]},
→           {type: 'womTableCell', children: [
→           {type: 'paragraph', children: [
→               {type: 'womTable', inline: true, children: [
→                   {type: 'womTableRow', children: [
→                       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'xxx'}]}]}
→                   ]} 
→               ]},
→           ]},
→           ]},
→           {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: '1'}]} 
→           ]},
→       ]},
→   ]},
→ ]},
→ ]}

〉Вложенная раскладка
←#|
←||ячейка-строка|
←#||
←  ||ячейка во вложенной таблице||
←||#
←||
←|#
→ {type: 'root', children: [
→   {type: 'womTable', inline: false, children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [
→         {type: 'paragraph', children: [{type: 'text', value: 'ячейка-строка'}]}
→       ]},
→       {type: 'womTableCell', children: [
→         {type: 'womTable', inline: false, kind: 'layout', children: [{type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'ячейка во вложенной таблице'}]} ]}]}]}
→       ]}
→     ]}
→   ]}
→ ]}

〉Вложенные таблицы
←#||
←|| cell10 | #| ||cell11.0|| |# | #| ||cell12.0|| |# | cell13 ||
←|| cell20 | #| ||cell21.0|| |# | #| ||cell22.0|| |# | cell23 ||
←||#
→ {type: 'root', children: [
→   {type: 'womTable', inline: false, kind: 'layout', children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [
→         {type: 'paragraph', children: [{type: 'text', value: 'cell10'}]}
→       ]},
→       {type: 'womTableCell', children: [
→       {type: 'paragraph', children: [
→         {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell11.0'}]} ]}]}
→         ]},
→       ]},
→       ]},
→       {type: 'womTableCell', children: [
→       {type: 'paragraph', children: [
→         {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell12.0'}]} ]}]}
→         ]},
→       ]},
→       ]},
→       {type: 'womTableCell', children: [
→         {type: 'paragraph', children: [{type: 'text', value: 'cell13'}]}
→       ]},
→     ]},
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [
→         {type: 'paragraph', children: [{type: 'text', value: 'cell20'}]}
→       ]},
→       {type: 'womTableCell', children: [
→       {type: 'paragraph', children: [
→         {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell21.0'}]} ]}]}
→         ]},
→       ]},
→       ]},
→       {type: 'womTableCell', children: [
→       {type: 'paragraph', children: [
→         {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'cell22.0'}]} ]}]}
→         ]},
→       ]},
→       ]},
→       {type: 'womTableCell', children: [
→         {type: 'paragraph', children: [{type: 'text', value: 'cell23'}]}
→       ]},
→     ]}
→   ]}
→ ]}

〉Очень вложенные таблицы
←#||
←|| cell10 | #| ||cell11.0| #| ||cell11.0.0|cell11.0.1|cell11.0.2|| |# |cell11.2|| |# | cell12 ||
←||#
→ {type: 'root', children: [
→   {type: 'womTable', inline: false, kind: 'layout', children: [
→       {type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: 'cell10'}]}
→           ]},
→           {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [
→                   {type: 'womTable', inline: true, children: [
→                       {type: 'womTableRow', children: [
→                           {type: 'womTableCell', children: [
→                               {type: 'paragraph', children: [{type: 'text', value: 'cell11.0'}]}
→                           ]},
→                           {type: 'womTableCell', children: [
→                           {type: 'paragraph', children: [
→                               {type: 'womTable', inline: true, children: [
→                                   {type: 'womTableRow', children: [
→                                       {type: 'womTableCell', children: [
→                                           {type: 'paragraph', children: [{type: 'text', value: 'cell11.0.0'}]}
→                                       ]},
→                                       {type: 'womTableCell', children: [
→                                           {type: 'paragraph', children: [{type: 'text', value: 'cell11.0.1'}]}
→                                       ]},
→                                       {type: 'womTableCell', children: [
→                                           {type: 'paragraph', children: [{type: 'text', value: 'cell11.0.2'}]}
→                                       ]},
→                                   ]}
→                               ]},
→                           ]},
→                           ]},
→                           {type: 'womTableCell', children: [
→                               {type: 'paragraph', children: [{type: 'text', value: 'cell11.2'}]}
→                           ]},
→                       ]}
→                   ]},
→               ]},
→           ]},
→           {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: 'cell12'}]}
→           ]},
→       ]}
→   ]}
→ ]}

〉¡ Таблица с пустыми ячейками в строках
←#| ||1||3|| |||5|6|| ||7|8||| |#
→ {type: 'root', children: [
→   {type: 'womTable', inline: false, children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1'}]}]},
→       {type: 'womTableCell', children: []},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '3'}]}]},
→     ]},
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: []},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '5'}]}]},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '6'}]}]},
→     ]},
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '7'}]}]},
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '8'}]}]},
→       {type: 'womTableCell', children: []},
→     ]},
→   ]}]}

〉Таблица с жирной строкой-заголовком
←#|
←**||Column 1|Column 2||**
←|| | ||
←|#
→ {type: 'root', children: [
→   {type: 'womTable', inline: false, children: [
→           {type: 'womTableRow', children: [
→             {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: 'Column 1'}]} ]},
→             {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [{type: 'text', value: 'Column 2'}]} ]},
→           ]},
→           {type: 'womTableRow', children: [
→             {type: 'womTableCell', children: [
→           ]},
→           {type: 'womTableCell', children: [
→           ]}]}
→ ]}]}

〉Таблица со стилизованной строкой в центре
←#|
←|| 1 | 2 ||
←**!!//||Column 1|Column 2||//!!**
←|| 3 | 4 ||
←|#
→{type: 'root', children: [
→  {type: 'womTable', inline: false, children: [
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [
→        {type: 'paragraph', children: [
→          {type: 'text', value: '1'}]}]},
→      {type: 'womTableCell', children: [
→        {type: 'paragraph', children: [
→          {type: 'text', value: '2'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [
→        {type: 'paragraph', children: [
→          {type: 'text', value: 'Column 1'}]}]},
→      {type: 'womTableCell', children: [
→        {type: 'paragraph', children: [
→          {type: 'text', value: 'Column 2'}]}]}
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [
→        {type: 'paragraph', children: [
→          {type: 'text', value: '3'}]}]},
→      {type: 'womTableCell', children: [
→        {type: 'paragraph', children: [
→          {type: 'text', value: '4'}]}]}
→  ]}]}]}

〉Таблица с по разному стилизованными строками
←#|
←**|| 1a | 1b ||**
←//|| 1a | 1b ||//
←__|| 1a | 1b ||__
←##|| 1a | 1b ||##
←++|| 1a | 1b ||++
←--|| 1a | 1b ||--
←??|| 1a | 1b ||??
←!!|| 1a | 1b ||!!
←|#
→{type: 'root', children: [
→  {type: 'womTable', inline: false, children: [
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→  ]},
→]}

〉Таблица с разноцветными строками
←#|
←!!(крас)|| 1a | 1b ||!!
←!!(зел)|| 1a | 1b ||!!
←!!(син)|| 1a | 1b ||!!
←!!(grey)|| 1a | 1b ||!!
←!!(yellow)|| 1a | 1b ||!!
←|#
→{type: 'root', children: [
→  {type: 'womTable', inline: false, children: [
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]},
→    {type: 'womTableRow', children: [
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1a'}]}]},
→      {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: '1b'}]}]},
→    ]}
→  ]},
→]}

〉Пустые ячейки
←#|
←|| Id | - ||||#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [{type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [
→     {type: 'paragraph', children: [{type: 'text', value: 'Id'}]}
→   ]},
→   {type: 'womTableCell', children: [
→     {type: 'paragraph', children: [{type: 'text', value: '-'}]}
→   ]},
→ ]}]}]}

〉Пустая таблица
←#| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, children: []},
→ ]}
→ ]}

〉Пустая таблица с внутренностями
←#| **//** |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, children: []},
→ ]}
→ ]}

〉Некорректые символы в начале таблицы
←#| абв**||ячейка|| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [
→     {type: 'paragraph', children: [{type: 'text', value: 'ячейка'}]}
→   ]}
→ ]}]}
→ ]}
→ ]}

〉Некорректые символы в конце таблицы
←#| ||ячейка|| абв**|#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [
→     {type: 'paragraph', children: [{type: 'text', value: 'ячейка'}]}
→   ]}
→ ]}]}
→ ]}
→ ]}

〉Битый кусок таблицы 1
←#|
→ {type: 'text', value: '#|'}

〉Битый кусок таблицы 2
←|#
→ {type: 'text', value: '|#'}

〉Битый кусок раскладки 1
←#||
→ {type: 'text', value: '#||'}

〉Битый кусок раскладки 2
←||#
→ {type: 'text', value: '||#'}

〉Битый кусок раскладка + таблица
←#|| |#
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'womTable', inline: true, kind: 'layout', children: []}]}]}

〉Битый кусок раскладка + таблица впритык
←#|||#
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'womTable', inline: true, children: []}]}]}

〉Битый кусок раскладка + # (или таблица без данных)
←#||#
→ {type: 'root', children: [{type: 'paragraph', children: [{type: 'text', value: '#||#'}]}]}

〉Таблица со строкой впритык 1
←#||| x || |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}
→ ]}]}
→ ]}
→ ]}

〉Таблица со строкой впритык 2
←#||| x |||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}
→ ]}]}
→ ]}
→ ]}

〉Таблица с одной строкой и двумя колонками впритык
←#||| | x |||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [{type: 'womTableRow', children: [
→   {type: 'womTableCell', children: []},
→   {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}
→ ]}]}
→ ]}
→ ]}

〉Таблица с двумя строками впритык
←#|||x||||y|||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'y'}]}]}]},
→ ]}
→ ]}
→ ]}

〉Раскладка с двумя строками впритык
←#||||c1|c2||||c3|c4||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c1'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c2'}]}]},
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c3'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c4'}]}]},
→   ]},
→ ]}
→ ]}
→ ]}

〉Раскладка с колонкой
←#|| || x ||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}
→   ]}
→ ]}
→ ]}
→ ]}

〉Раскладка с колонкой впритык
←#|||| x ||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]},
→   ]}
→ ]}
→ ]}
→ ]}

〉Раскладка с двумя колонками
←#|| ||x||||y||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'y'}]}]}]},
→ ]}
→ ]}
→ ]}

〉Раскладка с двумя колонками впритык
←#||||x||||y||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]},
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'y'}]}]},
→   ]},
→ ]}
→ ]}
→ ]}

〉Таблица в начале, раскладка в конце
←#||| x ||||#abcdef
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]},
→     ]}]},
→   {type: 'text', value: 'abcdef'},
→ ]}
→ ]}

〉Раскладка в начале, таблица в конце
←#|| || x || |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, kind: 'layout', children: [
→       {type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'x'}]}]}
→       ]}
→   ]}
→ ]}
→ ]}

〉Раскладка в начале, таблица в конце, с битой строкой
←#|| || x | |#
→ {type: 'womTable', inline: true, kind: 'layout', children: []}

〉Таблица с незакрытой строкой (WIKI-11913)
←#| ||a|| || |#
←#| ||b|| |#
→ {type: 'root', children: [
→   {type: 'paragraph', children: [
→       {type: 'text', value: '#| ||a|| || |#\n'},
→       {type: 'womTable', inline: true, children: [
→           {type: 'womTableRow', children: [
→               {type: 'womTableCell', children: [
→                   {type: 'paragraph', children: [{type: 'text', value: 'b'}]}
→               ]},
→           ]},
→       ]},
→   ]},
→ ]}

〉Таблица с неправильно закрытой строкой (WIKI-11913)
←#|
←||a|b||
←||a|b|
←|#
←#| ||b|| |#
→ {type: 'root', children: [
→   {type: 'paragraph', children: [
→       {type: 'text', value: '#|\n||a|b||\n||a|b|\n|#\n'},
→       {type: 'womTable', inline: true, children: [
→       {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [
→       {type: 'paragraph', children: [
→       {type: 'text', value: 'b'},
→       ]}
→       ]}
→       ]}
→       ]}
→   ]},
→ ]}

〉Таблица с неоткрытой строкой (WIKI-11913)
←#|
←||a|b||
←a|b||
←|#
←#| ||b|| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'text', value: '#|\n||a|b||\na|b||\n|#\n'},
→   {type: 'womTable', inline: true, children: [
→   {type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [
→   {type: 'paragraph', children: [
→   {type: 'text', value: 'b'},
→   ]}
→   ]}
→   ]}
→   ]}
→ ]}
→ ]}

〉Таблица с неправильно открытой строкой (WIKI-11913)
←#|
←||a|b||
←|a|b||
←|#
←#| ||b|| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'text', value: '#|\n||a|b||\n|a|b||\n|#\n'},
→   {type: 'womTable', inline: true, children: [
→   {type: 'womTableRow', children: [
→   {type: 'womTableCell', children: [
→   {type: 'paragraph', children: [
→   {type: 'text', value: 'b'},
→   ]}
→   ]}
→   ]}
→   ]}
→ ]}
→ ]}

〉Не ломаемся на #| 1 | ##||# (WIKI-11913)
←#| 1 | ##||#
→ {type: 'womTable', inline: true, children: []}

〉Таблица с womColor в ячейке
←#|
←|| a | b ||
←|| c | #ddd ||
←|#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'color', raw: '#ddd', value: 'ddd'}]}]}
→   ]}
→ ]}]}

〉Таблица с womMonospace в ячейке
←#|
←|| a | b ||
←|| c | ##monospace## ||
←|#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womMonospace', children: [{type: 'text', value: 'monospace'}]}]}]}
→   ]}
→ ]}]}

〉Таблица с womMonospace впритык
←#| ||ячейка1|##ячейка2 - моноширинная##|| |#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'ячейка1'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womMonospace', children: [{type: 'text', value: 'ячейка2 - моноширинная'}]}]}]}
→   ]}
→ ]}
→ ]}
→ ]}

〉Битая таблица с вложенной таблицей
←#|
←|| #| ||a| |# | b ||
←|| c | d ||
←|#
→ {type: 'root', children: [
→   {type: 'paragraph', children: [
→       {type: 'text', value: '#|\n|| '},
→       {type: 'womTable', inline: true, children: [
→           {type: 'womTableRow', children: [
→               {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [
→                   {type: 'text', value: 'a'},
→               ]},
→               ]},
→               {type: 'womTableCell', children: []},
→               {type: 'womTableCell', children: [
→               {type: 'heading', depth: 1, children: []},
→               ]},
→               {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [
→                   {type: 'text', value: 'b'},
→               ]},
→               ]},
→           ]},
→           {type: 'womTableRow', children: [
→               {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [
→                   {type: 'text', value: 'c'},
→               ]},
→               ]},
→               {type: 'womTableCell', children: [
→               {type: 'paragraph', children: [
→                   {type: 'text', value: 'd'},
→               ]},
→               ]},
→           ]},
→       ]},
→   ]},
→ ]}

〉Таблица с битой вложенной таблицей 2
←#|
←||a| #| |b ||
←||c|d||
←|#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'text', value: '#|\n||a| '},
→ {type: 'womTable', inline: true, children: [
→ {type: 'womTableRow', children: [
→   {type: 'womTableCell', children: []},
→ ]},
→ ]},
→ ]},
→ ]}

〉Таблица c текстом вокруг
←lalala #|
←||a|b||
←||c|d||
←|# lalala
→ {type: 'root', children: [
→   {type: 'paragraph', children: [
→     {type: 'text', value: 'lalala '},
→     {type: 'womTable', inline: true, children: [
→       {type: 'womTableRow', children: [
→         {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→         {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→       ]},
→       {type: 'womTableRow', children: [
→         {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→         {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'd'}]}]}
→       ]}
→     ]},
→     {type: 'text', value: ' lalala'}
→   ]}]}

〉Таблица с экранированием (~) внутри
←#|
←||a| ~#|||w|||# |b||
←||c|d||
←|#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [
→       {type: 'womEscape', raw: '~#|||w|||#', value: '#|||w|||#'},
→     ]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'd'}]}]}
→   ]}
→ ]}]}

〉Таблица с экранированием (~) внутри 2
←#|
←||a| ~#| |b||
←||c|d||
←|#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [
→       {type: 'womEscape', raw: '~#|', value: '#|'},
→     ]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'd'}]}]}
→   ]}
→ ]}]}

〉Таблица с экранированием ("") внутри
←#|
←||a| ""#| || escaped || |#"" |b||
←||c|d||
←|#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [
→       {type: 'womEscape', raw: '""#| || escaped || |#""', value: '#| || escaped || |#'},
→     ]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'd'}]}]}
→   ]}
→ ]}]}

〉Таблица с экранированием ("") внутри 2
←#|
←||a| ""#| || escaped"" |b||
←||c|d||
←|#
→ {type: 'root', children: [{type: 'womTable', inline: false, children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'a'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [
→       {type: 'womEscape', raw: '""#| || escaped""', value: '#| || escaped'},
→     ]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'b'}]}]}
→   ]},
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'c'}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'd'}]}]}
→   ]}
→ ]}]}

〉Таблица с различным экранированием
←#||||~#||||#
←~**текст**
←~~|
←""|текст|""
←""""
←""#|| |текст1
←текст2| ||#""
←||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, kind: 'layout', children: [
→       {type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [
→               {type: 'womEscape', raw: '~#||||#', value: '#||||#'},
→               {type: 'text', value: '\n'},
→               {type: 'womEscape', raw: '~**текст**', value: '**текст**'},
→               {type: 'text', value: '\n'},
→               {type: 'womEscape', raw: '~~', value: '~'},
→           ]}]},
→           {type: 'womTableCell', children: [{type: 'paragraph', children: [
→               {type: 'womEscape', raw: '""|текст|""', value: '|текст|'},
→               {type: 'text', value: '\n'},
→               {type: 'womEscape', raw: '""""', value: ''},
→               {type: 'text', value: '\n'},
→               {type: 'womEscape', raw: '""#|| |текст1\nтекст2| ||#""', value: '#|| |текст1\nтекст2| ||#'},
→           ]}
→           ]}
→       ]}
→   ]}
→ ]}
→ ]}

〉Таблица с вложенным вики-текстом
←#||||**текст**|##текст1##|++текст2++|//текст3//|!!текст4!!|__текст5__|??текст6??|!!(green)текст7!!|--текст8--||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→ {type: 'womTable', inline: true, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'strong', children: [{type: 'text', value: 'текст'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womMonospace', children: [{type: 'text', value: 'текст1'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womSmall', children: [{type: 'text', value: 'текст2'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womItalic', children: [{type: 'text', value: 'текст3'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womRemark', color: { type: 'color', value: '@red', raw: null}, children: [{type: 'text', value: 'текст4'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womUnderline', children: [{type: 'text', value: 'текст5'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womQuestion', children: [{type: 'text', value: 'текст6'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womRemark', color: { type: 'color', value: '@green', raw: 'green'}, children: [{type: 'text', value: 'текст7'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'womStrike', children: [{type: 'text', value: 'текст8'}]}]}]}
→   ]}
→ ]}
→ ]}
→ ]}

〉Таблица c пересечением маркеров
←#||||text1[[*text2||||#text3]]
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, kind: 'layout', children: [
→     {type: 'womTableRow', children: [
→       {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'text', value: 'text1\[\[*text2'}]}]},
→     ]},
→   ]},
→   {type: 'text', value: 'text3\]\]'}
→ ]}
→ ]}

〉Таблица с ссылками
←#||
←||
←http://st.woof-team.ru/WIKI-456|
←http://st.woof-team.ru/WIKI-789|
←http://st.woof-team.ru/234
←||
←||#
→ {type: 'root', children: [{type: 'womTable', inline: false, kind: 'layout', children: [
→   {type: 'womTableRow', children: [
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'link', title: null, url: 'http://st.woof-team.ru/WIKI-456', children: [{type: 'text', value: 'http://st.woof-team.ru/WIKI-456'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'link', title: null, url: 'http://st.woof-team.ru/WIKI-789', children: [{type: 'text', value: 'http://st.woof-team.ru/WIKI-789'}]}]}]},
→     {type: 'womTableCell', children: [{type: 'paragraph', children: [{type: 'link', title: null, url: 'http://st.woof-team.ru/234', children: [{type: 'text', value: 'http://st.woof-team.ru/234'}]}]}]}
→   ]}
→ ]}]}

〉Таблица с womHtml
←#||||<# html-start <input type="<[text]>"> #>|
←<##>
←||||#
→ {type: 'root', children: [
→ {type: 'paragraph', children: [
→   {type: 'womTable', inline: true, kind: 'layout', children: [
→       {type: 'womTableRow', children: [
→           {type: 'womTableCell', children: [
→               {type: 'womHtml', inline: false, value: 'html-start <input type="<[text]>">'}
→           ]},
→           {type: 'womTableCell', children: [
→               {type: 'womHtml', inline: false, value: ''}
→           ]},
→       ]}
→   ]}
→]}
→]}

〉Таблица со смещенным списком внутри ячейки
←#|
←||
←  * ненумерованный список-1
←  * ненумерованный список-2
←||
←|#
→{type: 'root', children: [
→{type: 'womTable', inline: false, children: [
→{type: 'womTableRow', children: [
→{type: 'womTableCell', children: [
→{type: 'list', ordered: false, start: null, loose: false, children: [
→{type: 'listItem', loose: false, checked: null, expandable: false, restart: null, children: [
→{type: 'paragraph', children: [{type: 'text', value: 'ненумерованный список-1'}]}
→]},
→{type: 'listItem', loose: false, checked: null, expandable: false, restart: null, children: [
→{type: 'paragraph', children: [{type: 'text', value: 'ненумерованный список-2'}]}
→]},
→]}
→]}
→]}
→]}
→]}
