const { parseTheContainerAt } = require('../utils/parse-container-at');
const { getNodeOuterText } = require('../utils/skip-blocks-utils');
const { createMdAstWomTableNode } = require('../lib/tokenize-skip-node/wom-table');
const {
    inlineWomTable,
    blockWomTable,
} = require('../utils/skip-blocks');

function womTable({ inline }) {
    const container = inline ?
        inlineWomTable :
        blockWomTable;

    function tokenizer(eat, value) {
        const outerNode = parseTheContainerAt(container, value, 0);
        const { outerFirstIndex } = outerNode;

        if (outerFirstIndex < 0) {
            return false;
        }

        const now = eat.now();

        eat(getNodeOuterText(value, outerNode))(
            createMdAstWomTableNode(this, value, now, outerNode)
        );
    }

    tokenizer.locator = (value, fromIndex) =>
        value.indexOf('#|', fromIndex);

    return tokenizer;
}

exports.womTable = womTable;
