## Базовые строчные элементы

←**Полужирный текст**
↑ STARS TEXT STARS
→ {type: 'strong', children: [{type: 'text', value: 'Полужирный текст'}]}

←//Курсивный текст//
↑ SLASHES TEXT SLASHES
→ {type: 'womItalic', children: [{type: 'text', value: 'Курсивный текст'}]}

←//Курсивный \//текст//
↑ SLASHES TEXT SLASHES
→ {type: 'womItalic', children: [{type: 'text', value: 'Курсивный '}, {type: 'text', value: '/'}, {type: 'text', value: '/текст'}]}

←__Подчеркнутый текст__
↑ LODASHES TEXT LODASHES
→ {type: 'womUnderline', children: [{type: 'text', value: 'Подчеркнутый текст'}]}

←##Моноширинный текст##
↑ TEXT
→ {type: 'womMonospace', children: [{type: 'text', value: 'Моноширинный текст'}]}

←++Мелкий текст++
↑ PLUSES TEXT PLUSES
→ {type: 'womSmall', children: [{type: 'text', value: 'Мелкий текст'}]}

←--Зачеркнутый текст--
↑ MINUSES TEXT MINUSES
→ {type: 'womStrike', children: [{type: 'text', value: 'Зачеркнутый текст'}]}

←~~Зачеркнутый текст~~
↑ TILDES TEXT TILDES
→ {type: 'delete', children: [{type: 'text', value: 'Зачеркнутый текст'}]}

←??Вопрос??
↑ QUESTIONS TEXT QUESTIONS
→ {type: 'womQuestion', children: [{type: 'text', value: 'Вопрос'}]}

←??Вопрошение???
↑ EXCLAMATIONS TEXT EXCLAMATIONS
→ [{type: 'womQuestion', children: [{type: 'text', value: 'Вопрошение'}]}, {type: 'text', value: '?'}]

〉Пробелы после маркера
←** Полужирный текст**
→ {type: 'text', value: '** Полужирный текст**'}

〉Пробелы до закрывающего маркера
←**Полужирный текст **
→ {type: 'text', value: '**Полужирный текст **'}

〉Пробелы вокруг маркеров
←** Полужирный текст **
→ {type: 'text', value: '** Полужирный текст **'}

〉Многострочное strong форматирование
←текст текст **Полужирный текст
←с переносом** текст текст
→ [
→   {type: 'text', value: 'текст текст '},
→   {type: 'strong', children: [{type: 'text', value: 'Полужирный текст\nс переносом'}]},
→   {type: 'text', value: ' текст текст'}
→ ]

〉Смешение
←??Вопрошение++??++??
→ { type: 'root', children: [
→   { type: 'paragraph', children: [
→     { type: 'womQuestion', children: [
→       { type: 'text', value: 'Вопрошение++' } ]}, { type: 'text', value: '++??' }]}]}

〉Множественные ##
←Привет###########
→ [{type: 'text', value: 'Привет###########'}]

〉Множественные ??
←Привет???????????
→ [{type: 'text', value: 'Привет???????????'}]

〉Множественные **
←Привет***********
→ {type: 'text', value: 'Привет***********'}

〉Множественные ++
←Привет+++++++++++
→ [{type: 'text', value: 'Привет+++++++++++'}]

〉Множественные ^^
←Привет^^^^^^^^^^^
→ [{type: 'text', value: 'Привет^^^^^^^^^^^'}]

〉Множественные vv
←Приветvvvvvvvvvvv
→ [{type: 'text', value: 'Приветvvvvvvvvvvv'}]

〉Начальные множественные ***
←***Полужирный текст******
→ [{type: 'strong', children: [{type: 'text', value: '*Полужирный текст'}]}, {type: 'text', value: '****'}]

〉Начальные множественные ///
←///Курсивный текст/////
→ [{type: 'womItalic', children: [{type: 'text', value: '/Курсивный текст'}]}, {type: 'text', value: '///'}]

〉Начальные множественные ___
←___Подчеркнутый текст_____
→ [{type: 'womUnderline', children: [{type: 'text', value: '_Подчеркнутый текст'}]}, {type: 'text', value: '___'}]

〉Начальные множественные ###
←###Моноширинный текст#####
→ [{type: 'womMonospace', children: [{type: 'text', value: '#Моноширинный текст'}]}, {type: 'text', value: '###'}]

〉Начальные множественные +++
←+++Мелкий текст++++++
→ [{type: 'womSmall', children: [{type: 'text', value: '+Мелкий текст'}]}, {type: 'text', value: '++++'}]

〉Начальные множественные ???
←???Вопрос????????
→ [{type: 'womQuestion', children: [{type: 'text', value: '?Вопрос'}]}, {type: 'text', value: '??????'}]

""**Жирный текст**"" → {type: 'womEscape', raw: '""**Жирный текст**""', value: '**Жирный текст**'}
~**Жирный_текст** → {type: 'womEscape', raw: '~**Жирный_текст**', value: '**Жирный_текст**'}

〉Верхний индекс
←E=mc^^2^^
↑ TEXT CARETS TEXT CARETS
→ {type: 'paragraph', children: [{type: 'text', value: 'E=mc'}, {type: 'womSuperscript', children: [{type: 'text', value: '2'}]}]}

〉Нижний индекс
←H vv2vv O
↑ TEXT VLETTERS TEXT VLETTERS TEXT
→ {type: 'paragraph', children: [{type: 'text', value: 'H '}, {type: 'womSubscript', children: [{type: 'text', value: '2'}]}, {type: 'text', value: ' O'}]}

〉Нижний индекс без пробелов
←H""""vv2vv""""O
↑ TEXT QUOTES QUOTES VLETTERS TEXT VLETTERS QUOTES QUOTES TEXT
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'H'},
→   {type: 'womEscape', raw:'""""', value: ''},
→   {type: 'womSubscript', children: [{type: 'text', value: '2'}]},
→   {type: 'womEscape', raw:'""""', value: ''},
→   {type: 'text', value: 'O'}
→ ]}

〉Присвоение цвета
← #ff0000 или #F00
↑ COLOR TEXT COLOR
→ {type: 'paragraph', children: [
→   {type: 'color', raw: '#ff0000', value: 'ff0000'},
→   {type: 'text', value: ' или '},
→   {type: 'color', raw: '#F00', value: 'f00'}
→ ]}

## Разделители (break)

←---
↑ HYPHENS
→ {type: 'root', children: [{type: 'thematicBreak'}]}

←____
↑ LODASHES
→ {type: 'root', children: [{type: 'thematicBreak'}]}

〉Явный перевод строки
←тест---шмест
↑ TEXT HYPHENS TEXT
→ {type: 'paragraph', children: [{type: 'text', value: 'тест'}, {type: 'womBreak', raw: '---'}, {type: 'text', value: 'шмест'}]}

〉Однострочные переводы пачкой
←тест---шмест---гдест?---нигдест
↑ TEXT HYPHENS TEXT HYPHENS TEXT HYPHENS TEXT
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'тест'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'шмест'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'гдест?'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'нигдест'},
→ ]}

〉Переводы пачкой с зачеркнутым (feat strike)
←тест---шмест--зарезано--да---еще
↑ TEXT HYPHENS TEXT HYPHENS TEXT HYPHENS TEXT
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'тест'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'шмест'},
→   {type: 'womStrike', children: [
→     {type: 'text', value: 'зарезано'}
→   ]},
→   {type: 'text', value: 'да'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'еще'},
→ ]}

〉Переводы со всех сторон
←---тест---шмест---квест---
→ [
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'тест'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'шмест'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'квест'},
→   {type: 'womBreak', raw: '---'},
→ ]

## Термины (definition)

〉Термин
←(?Термин Вот тут всплыло развернутое определение термина?)
↑ LDEFINITION TEXT WS TEXT RDEFINITION
→ {type: 'womDefinition', inline: true, title: 'Термин', equals: false, value: 'Вот тут всплыло развернутое определение термина'}

〉Термин с пробелами
←(?Термин с пробелами==И тут тоже всплыло развернутое определение термина с пробелами?)
↑ LDEFINITION TEXT EQUALS TEXT RDEFINITION
→ {type: 'womDefinition', inline: true, title: 'Термин с пробелами', equals: true, value: 'И тут тоже всплыло развернутое определение термина с пробелами'}

〉Термины подряд разные
←(?Термин Описалово?)(?Еще==Еще описалово?)
↑ LDEFINITION TEXT WS TEXT RDEFINITION
→ [
→   {type: 'womDefinition', inline: true, title: 'Термин', equals: false, value: 'Описалово'},
→   {type: 'womDefinition', inline: true, title: 'Еще', equals: true, value: 'Еще описалово'}
→ ]

〉Термины в тексте
←Текст и тут (?Термин Описалово?), а потом еще текст и (?Еще термин==Еще описалово?). И текст в конце
↑ LDEFINITION TEXT WS TEXT RDEFINITION
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'Текст и тут '},
→   {type: 'womDefinition', inline: true, title: 'Термин', equals: false, value: 'Описалово'},
→   {type: 'text', value: ', а потом еще текст и '},
→   {type: 'womDefinition', inline: true, title: 'Еще термин', equals: true, value: 'Еще описалово'},
→   {type: 'text', value: '. И текст в конце'},
→ ]}

## Заголовки (heading)

〉Один знак равно это не заголовок
←= Не заголовок
→ {type: 'text', value: '= Не заголовок'}

〉Большой заголовок
←== Большой заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 1, anchor: null, expandable: false, children: [{type: 'text', value: 'Большой заголовок'}]}]}

〉Большой заголовок
←==+ Большой раскрывающийся заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 1, anchor: null, expandable: true, children: [{type: 'text', value: 'Большой раскрывающийся заголовок'}]}]}

〉Большой заголовок с якорем
←==(intro) Введение
→ {type: 'root', children: [{type: 'womHeading', depth: 1, anchor: 'intro', expandable: false, children: [{type: 'text', value: 'Введение'}]}]}

〉Большой раскрывающийся заголовок с якорем
←==+(intro) Введение
→ {type: 'root', children: [{type: 'womHeading', depth: 1, anchor: 'intro', expandable: true, children: [{type: 'text', value: 'Введение'}]}]}

〉Раскрывающийся заголовок после якоря
←==(intro)+ Введение
→ {type: 'root', children: [{type: 'womHeading', depth: 1, anchor: 'intro', expandable: true, children: [{type: 'text', value: 'Введение'}]}]}

〉Большой заголовок без якоря, но со скобками в начале
←==() Введение
→ {type: 'root', children: [{type: 'womHeading', depth: 1, anchor: '', expandable: false, children: [{type: 'text', value: 'Введение'}]}]}

〉Заголовок поменьше
←=== Заголовок поменьше
→ {type: 'root', children: [{type: 'womHeading', depth: 2, anchor: null, expandable: false, children: [{type: 'text', value: 'Заголовок поменьше'}]}]}

〉Средний заголовок
←==== Средний заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 3, anchor: null, expandable: false, children: [{type: 'text', value: 'Средний заголовок'}]}]}

〉Маленький заголовок
←===== Маленький заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 4, anchor: null, expandable: false, children: [{type: 'text', value: 'Маленький заголовок'}]}]}

〉Ну совсем маленький заголовок
←====== Ну совсем маленький заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 5, anchor: null, expandable: false, children: [{type: 'text', value: 'Ну совсем маленький заголовок'}]}]}

〉Меньше некуда заголовок
←======= Меньше некуда заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 6, anchor: null, expandable: false, children: [{type: 'text', value: 'Меньше некуда заголовок'}]}]}

〉Меньше некуда заголовок с равно на конце
←======= Меньше некуда заголовок ====================
→ {type: 'root', children: [{type: 'womHeading', depth: 6, anchor: null, expandable: false, children: [{type: 'text', value: 'Меньше некуда заголовок'}]}]}

〉Меньше некуда заголовок с раскрывашкой
←=======+ Меньше некуда раскрывающийся заголовок
→ {type: 'root', children: [{type: 'womHeading', depth: 6, anchor: null, expandable: true, children: [{type: 'text', value: 'Меньше некуда раскрывающийся заголовок'}]}]}

〉Много знаков равно это тоже не заголовок
←======== Не заголовок
→ {type: 'text', value: '======== Не заголовок'}

〉Заголовок с форматированием (feat formatter)
←== Библиотека %%глазировка%%
→ {type: 'root', children: [
→   {type: 'womHeading', depth: 1, anchor: null, expandable: false, children: [
→     {type: 'text', value: 'Библиотека '},
→     {type: 'womFormatter', inline: true, value: 'глазировка'}
→   ]}]}

〉Заголовок со ссылкой
←===((https://ya.ru Yandex))
→{"type":"root","children":[{"type":"womHeading","depth":2,"anchor":null,"expandable":false,"children":[{"type":"womLink","url":"https://ya.ru","brackets":false,"children":[{"type":"text","value":"Yandex"}]}]}]}

## Сноски (footnote, reference, definition)

〉Сноски
←Текст, потом сноска[[*]] и вторая[[**]]
→ {type: 'paragraph', children: [{type: 'text', value: 'Текст, потом сноска'}, {type: 'womFootnoteReference', identifier: '', "label": null}, {type: 'text', value: ' и вторая'}, {type: 'womFootnoteReference', identifier: '*', "label": null}]}

〉Еще сноски
←Текст, потом цифровая сноска[[*1]] и вторая[[*2]]
→ {type: 'paragraph', children: [{type: 'text', value: 'Текст, потом цифровая сноска'}, {type: 'womFootnoteReference', identifier: '1', "label": null}, {type: 'text', value: ' и вторая'}, {type: 'womFootnoteReference', identifier: '2', "label": null}]}

〉Это [[*)) не сноска
←Это [[*)) не сноска
→ {type: 'paragraph', children: [{type: 'text', value: 'Это [[*)) не сноска'}]}

〉Сноски в круглых скобках
←Текст, потом сноска((*)) и цифровая сноска((*1))
→ {type: 'paragraph', children: [{type: 'text', value: 'Текст, потом сноска'}, {type: 'womFootnoteReference', identifier: '', "label": null}, {type: 'text', value: ' и цифровая сноска'}, {type: 'womFootnoteReference', identifier: '1', "label": null}]}

〉Cноска с ярлыком
←[[*id label]] Cноска с ярлыком
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteReference', identifier: 'id', "label": "label"},
→   {type: 'text', value: ' Cноска с ярлыком'}
→ ]}

〉Cноска с ярлыком c пробелами
←[[*id label with spaces]] Cноска с ярлыком c пробелами
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteReference', identifier: 'id', "label": "label with spaces"},
→   {type: 'text', value: ' Cноска с ярлыком c пробелами'}
→ ]}

〉Расшифровка первой сноски
←[[#*]] Расшифровка первой сноски
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: '*', "label": null},
→   {type: 'text', value: ' Расшифровка первой сноски'}
→ ]}

〉Расшифровка второй сноски
←[[#**]] Расшифровка второй сноски
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: '**', "label": null},
→   {type: 'text', value: ' Расшифровка второй сноски'}
→ ]}

〉Расшифровка цифровой сноски
←[[#1]] Расшифровка цифровой сноски
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: '1', "label": null},
→   {type: 'text', value: ' Расшифровка цифровой сноски'}
→ ]}

〉Расшифровка сноски в круглых скобках
←((#1)) Расшифровка сноски в круглых скобках
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: '1', "label": null},
→   {type: 'text', value: ' Расшифровка сноски в круглых скобках'}
→ ]}

〉Расшифровка сноски с ярлыком
←[[#id label]] Расшифровка сноски с ярлыком
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: 'id', "label": "label"},
→   {type: 'text', value: ' Расшифровка сноски с ярлыком'}
→ ]}

〉Расшифровка сноски без id
←[[#]] Расшифровка сноски без id
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: '', "label": null},
→   {type: 'text', value: ' Расшифровка сноски без id'}
→ ]}

〉Расшифровка сноски без id c ярлыком
←[[# lab el]] Расшифровка сноски без id c ярлыком
→ { type: 'paragraph', children: [
→   {type: 'womFootnoteDefinition', identifier: '', "label": "lab el"},
→   {type: 'text', value: ' Расшифровка сноски без id c ярлыком'}
→ ]}

## tilde-based

〉Код через ~
←~~~
←code
←~~~
→ {type: 'root', children: [{type: 'code', lang: null, meta: null, value: 'code'}]}

〉Тильда ~ внутри текста
←Тильда ~ внутри текста
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'Тильда ~ внутри текста'},
→ ]}

〉~~strike~~ some text ~~~ ~!!red!!
←~~strike~~ some text ~~~ ~!!red!!
→ {type: 'paragraph', children: [
→   {type: 'delete', children: [{type: 'text', value: 'strike'}]},
→   {type: 'text', value: ' some text '},
→   {type: 'womEscape', raw: '~~', value: '~'},
→   {type: 'text', value: '~ '},
→   {type: 'womEscape', raw: '~!!red!!', value: '!!red!!'}
→ ]}

〉~~ ~~
←~~ ~~
→ {type: 'paragraph', children: [
→   {type: 'womEscape', raw: '~~', value: '~'},
→   {type: 'text', value: ' '},
→   {type: 'womEscape', raw: '~~', value: '~'}
→ ]}

〉aa ~bb--- cc
←aa ~bb--- cc
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'aa '},
→   {type: 'womEscape', raw: '~bb---', value: 'bb---'},
→   {type: 'text', value: ' cc'}
→ ]}

〉aa ~~bb--- cc
←aa ~~bb--- cc
→ {type: 'paragraph', children: [
→   {type: 'text', value: 'aa '},
→   {type: 'womEscape', raw: '~~', value: '~'},
→   {type: 'text', value: 'bb'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: ' cc'}
→ ]}

## Экшны (actions)

〉НЕэкшн с текстом перед ним
←blablaska {{n root=HomePage }}
→[{ type: 'text', value: 'blablaska {{n root=HomePage }}'}]

〉Инлайн экшн с текстом перед ним
←blablaska {{a root=HomePage }}
→[{ type: 'text', value: 'blablaska ' }, {type: 'womAction', inline: true, name: 'a', params: { root: 'HomePage' }}]

〉Два блочных экшена подряд в строке
←{{include}}{{include}}
→{ type: 'text', value: '{{include}}{{include}}' }

## Строчные обертки ссылок
〉Не закрытый emphasis + ссылка с разделителем внутри (_)
←_[test](https://_)
→ [{type: 'text', value: '_'}, {type: 'link', title: null, url: 'https://_', children: [{type: 'text', value: 'test'}]}]

〉Закрытый emphasis + ссылка с разделителем внутри (_)
←_[test](https://_)_
→ {type: 'emphasis', children: [{type: 'link', title: null, url: 'https://_', children: [{type: 'text', value: 'test'}]}]}

〉Не закрытый emphasis + ссылка с разделителем внутри (*)
←*[test](https://*)
→ [{type: 'text', value: '*'}, {type: 'link', title: null, url: 'https://*', children: [{type: 'text', value: 'test'}]}]

〉Закрытый emphasis + ссылка с разделителем внутри (*)
←*[test](https://*)*
→ {type: 'emphasis', children: [{type: 'link', title: null, url: 'https://*', children: [{type: 'text', value: 'test'}]}]}

〉Markdown гиперссылка, обернутая в WOM italic (escape)
←//[Ссылка](https:\//test)//
→ {type: 'womItalic', children: [{type: 'link', title: null, url: 'https://test', children: [{type: 'text', value: 'Ссылка'}]}]}

〉Markdown гиперссылка, обернутая в WOM italic
←//[Ссылка](https://test)//
→ {type: 'womItalic', children: [{type: 'link', title: null, url: 'https://test', children: [{type: 'text', value: 'Ссылка'}]}]}

〉Markdown гиперссылка, обернутая в bold (escape)
←**[Ссылка](https://\**)**
→ {type: 'strong', children: [{type: 'link', title: null, url: 'https://**', children: [{type: 'text', value: 'Ссылка'}]}]}

〉Markdown гиперссылка, обернутая в bold
←**[Ссылка](https://**)**
→ {type: 'strong', children: [{type: 'link', title: null, url: 'https://**', children: [{type: 'text', value: 'Ссылка'}]}]}

〉Несколько Markdown гиперссылок, обернутых в WOM italic
←//[Ссылка](https://test) што [Ссылка](https://test) што [Ссылка](https://test)//
→ {type: 'womItalic', children: [{type: 'link', title: null, url: 'https://test', children: [{type: 'text', value: 'Ссылка'}]}, {type: 'text', value: ' што '}, {type: 'link', title: null, url: 'https://test', children: [{type: 'text', value: 'Ссылка'}]}, {type: 'text', value: ' што '}, {type: 'link', title: null, url: 'https://test', children: [{type: 'text', value: 'Ссылка'}]}]}

〉WOM ((гиперссылка)), обернутая в WOM italic
←//((https://test Ссылка))//
→ {type: 'womItalic', children: [{type: 'womLink', url: 'https://test', brackets: false, children: [{type: 'text', value: 'Ссылка'}]}]}

〉WOM ((гиперссылка)), обернутая в WOM italic
←//((https://test// Ссылка))//
→ {type: 'womItalic', children: [{type: 'womLink', url: 'https://test//', brackets: false, children: [{type: 'text', value: 'Ссылка'}]}]}

〉WOM [[гиперссылка]], обернутая в WOM italic
←//[[https://test Ссылка]]//
→ {type: 'womItalic', children: [{type: 'womLink', url: 'https://test', brackets: true, children: [{type: 'text', value: 'Ссылка'}]}]}

〉WOM [[гиперссылка]], обернутая в WOM remark (explicit)
←!!(зел)((https://ya.ru ссылка))!!
→{type: 'womRemark', color: {type: 'color', value: '@green', raw: 'зел'}, children: [
→   {type: 'womLink', url: 'https://ya.ru', brackets: false, children: [{type: 'text', value: 'ссылка'}]}
→]}

〉WOM [[гиперссылка]], обернутая в WOM remark (implicit)
←!!((https://ya.ru ссылка))!!
→{type: 'womRemark', color: {type: 'color', value: '@red', raw: null}, children: [
→   {type: 'womLink', url: 'https://ya.ru', brackets: false, children: [{type: 'text', value: 'ссылка'}]}
→]}

## https://spec.commonmark.org/0.29/#inlines
←**foo bar**
→ {type: 'strong', children: [{type: 'text', value: 'foo bar'}]}

←a ** foo bar**
→ {type: 'text', value: 'a ** foo bar**'}

Это правильное поведение emphasis (_)
←test_test_test
→{type: 'text', value: 'test_test_test'}

←test*test*test
→[
→   {type: 'text', value: 'test'},
→   {type: 'emphasis', children: [{type: 'text', value: 'test'}]},
→   {type: 'text', value: 'test'},
→]

←test//test//test
→[
→   {type: 'text', value: 'test'},
→   {type: 'womItalic', children: [{type: 'text', value: 'test'}]},
→   {type: 'text', value: 'test'},
→]

←--strike--strike---what
→[
→   {type: 'womStrike', children: [{type: 'text', value: 'strike'}]},
→   {type: 'text', value: 'strike'},
→   {type: 'womBreak', raw: '---'},
→   {type: 'text', value: 'what'},
→]

←**text****
→{type: 'root', children: [
→{type: 'paragraph', children: [
→{type: 'strong', children: [
→{type: 'text', value: 'text'},
→]},
→{type: 'text', value: '**'},
→]}
→]}

←test_test_
→{type: 'root', children: [
→{type: 'paragraph', children: [
→{type: 'text', value: 'test_test_'},
→]}
→]}
