module.exports = [
    {
        group: 'link',
        tests: [
            {
                markup: '[added: https://ya.ru]',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'linkReference', identifier: 'added: https://ya.ru', label: 'added: https://ya.ru', referenceType: 'shortcut', children: [
                            { type: 'text', value: 'added: ' },
                            { type: 'link', title: null, url: 'https://ya.ru', children: [
                                { type: 'text', value: 'https://ya.ru' },
                            ] },

                        ] },
                    ] },
                ] },
            },
            {
                markup: 'This should be a link: http://example.com/hello-world.',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'This should be a link: ' },
                        { type: 'link', title: null, url: 'http://example.com/hello-world', children: [
                            { type: 'text', value: 'http://example.com/hello-world' },
                        ] },
                        { type: 'text', value: '.' },
                    ] },
                ] },
            },
            {
                markup: 'Same for https: https://example.com/hello-world.',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'Same for https: ' },
                        { type: 'link', title: null, url: 'https://example.com/hello-world', children: [
                            { type: 'text', value: 'https://example.com/hello-world' },
                        ] },
                        { type: 'text', value: '.' },
                    ] },
                ] },
            },
            {
                markup: 'Also, subdomain should be a part of the link (http://foo.example.com/(hello[world])).',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'Also, subdomain should be a part of the link (' },
                        { type: 'link', title: null, url: 'http://foo.example.com/(hello[world])', children: [
                            { type: 'text', value: 'http://foo.example.com/(hello[world])' },
                        ] },
                        { type: 'text', value: ').' },
                    ] },
                ] },
            },
            {
                markup: 'So should this: mailto:foo@bar.com',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'So should this: ' },
                        { type: 'link', title: null, url: 'mailto:foo@bar.com', children: [
                            { type: 'text', value: 'foo@bar.com' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'ref:http://img.woofmd.net/i/logo95x37x8.png.',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'link', title: null, url: 'http://img.woofmd.net/i/logo95x37x8.png', ref: true, children: [
                            { type: 'text', value: 'http://img.woofmd.net/i/logo95x37x8.png' },
                        ] },
                        { type: 'text', value: '.' },
                    ] },
                ] },
            },
            {
                markup: 'ref:https://img.woofmd.net/i/logo95x37x8.png',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'link', title: null, url: 'https://img.woofmd.net/i/logo95x37x8.png', ref: true, children: [
                            { type: 'text', value: 'https://img.woofmd.net/i/logo95x37x8.png' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'file:/group/gods/dog.jpg',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'link', title: null, url: 'file:/group/gods/dog.jpg', children: [
                            { type: 'text', value: 'file:/group/gods/dog.jpg' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'file:https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'file:' },
                        { type: 'link', title: null, url: 'https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png', children: [
                            { type: 'text', value: 'https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'Some text file:https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'Some text file:' },
                        { type: 'link', title: null, url: 'https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png', children: [
                            { type: 'text', value: 'https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'MAILTO:mail@mail.ru',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'link', title: null, url: 'MAILTO:mail@mail.ru', children: [
                            { type: 'text', value: 'mail@mail.ru' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'some text MAILTO:mail@mail.ru',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'some text MAILTO:mail@mail.ru' },
                    ] },
                ] },
            },
            {
                markup: 'No at mailto:mailmail.ru',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'No at mailto:mailmail.ru' },
                    ] },
                ] },
            },
            {
                markup: 'ref:file:/users/masloval/mobiletest.jpg',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'link', title: null, url: 'file:/users/masloval/mobiletest.jpg', ref: true, children: [
                            { type: 'text', value: 'file:/users/masloval/mobiletest.jpg' },
                        ] },
                    ] },
                ] },
            },
            {
                markup: 'ref:file:https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png',
                expect: { type: 'root', children: [
                    { type: 'paragraph', children: [
                        { type: 'text', value: 'ref:file:' },
                        { type: 'link', title: null, url: 'https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png', children: [
                            { type: 'text', value: 'https://jing.yandex-team.ru/files/ljql/shutter%202020-03-20%2012%3A51%3A18.png' },
                        ] },
                    ] },
                ] },
            },
        ],
    },
];
