/**
 * Look for index of input string matching test function
 *
 * @param {String} input - search string
 * @param {Number} offset
 * @param {function} test
 * @returns {Number}
 */
function lookahead(input, offset, test) {
    const l = input.length;
    let i = offset;

    while (i < l) {
        if (test(input[i])) {
            return i;
        }

        i += 1;
    }

    return -1;
}

exports.lookahead = lookahead;
