const { isEscaped } = require('./spec');
const { parseTheContainerAt } = require('./parse-container-at');

function parseAnyContainerAt(containers, value, fromIndex) {
    const containersCount = containers.length;

    for (let i = 0; i < containersCount; i += 1) {
        const outerNode = parseTheContainerAt(containers[i], value, fromIndex);

        if (outerNode.outerFirstIndex < 0) {
            continue;
        }

        return outerNode;
    }

    return null;
}

function findMatchBetween(containers, value, fromIndex, nextIndex, matchAt) {
    let prevIndex = fromIndex;
    let currIndex = fromIndex;

    outer: do {
        // Нашли ближайший перенос строки
        let matchIndex = matchAt(currIndex);

        if (matchIndex < 0) {
            // Не матчится
            currIndex += 1;
            continue;
        }

        if (isEscaped(value, currIndex)) {
            // Заэкранировано
            currIndex += 1;
            continue;
        }

        if (matchIndex > nextIndex) {
            // Если матч выходит за пределы поиска, то выходим
            break;
        }

        currIndex = matchIndex;

        for (let i = prevIndex; i < currIndex; i += 1) {
            // Пытаемся распарсить контейнер до начала матча
            const outerNode = parseAnyContainerAt(containers, value, i);

            if (!outerNode) {
                // Контейнер не распарсился на этом индексе, пробуем другой индекс
                continue;
            }

            // Контейнер распарсился
            const { outerFirstIndex } = outerNode;

            if (outerFirstIndex > nextIndex) {
                // Контейнер выходит за пределы nextIndex, матч не найден.
                // Выходим из этого цикла, и отдаем управление внешнему,
                // потому что какие-то контейнеры могли распарсится в предыдущих итерациях
                break;
            }

            if (outerFirstIndex < currIndex) {
                // Контейнер распарсился ДО начала матча.
                // Значит надо попробовать распарсить еще
                i = outerFirstIndex - 1;

                continue;
            }

            // Край распаршенного котейнера выходит за рамки матча.
            // Значит надо продолжить внешний цикл, если только
            // найденный конец контейнера не выходит за пределы начала поиска
            if (outerFirstIndex < nextIndex) {
                currIndex = outerFirstIndex;
                prevIndex = outerFirstIndex;

                continue outer;
            }

            return outerFirstIndex;
        }

        // Никакой контейнер не распарсился,
        // значит искомое найдено
        return currIndex;
    } while (currIndex < nextIndex);

    // Искомый матч вне контейнеров не был найден
    return -1;
}

function findLineEndBetween(containers, value, fromIndex, nextIndex) {
    const valueLength = value.length;

    return findMatchBetween(containers, value, fromIndex, nextIndex, i => {
        if (value[i] === '\n') {
            return i;
        }

        if (i + 1 === valueLength) {
            return i + 1;
        }

        return -1;
    });
}

exports.parseAnyContainerAt = parseAnyContainerAt;
exports.findMatchBetween = findMatchBetween;
exports.findLineEndBetween = findLineEndBetween;
