/**
 * Все контейнеры нужно импортировать именно отсюда,
 * потому что тут, кроме всего прочего, наполняются списки,
 * от которых они сами и зависят
 * */
const {
    defaultBlockChildren,
    defaultInlineChildren,
} = require('./skip-blocks/possible-children');

/****/
/* Парсеры контейнеров */
/****/

// Wom обертка (block)
const { blockWomMarkdown } = require('./skip-blocks/wom-markdown');

// Wom обертка (inline)
const { inlineWomMarkdown } = require('./skip-blocks/wom-markdown');

// Wom форматтер кода (block)
const { blockWomFormatter } = require('./skip-blocks/wom-formatter');

// Wom-форматтер кода (inline)
const { inlineWomFormatter } = require('./skip-blocks/wom-formatter');

// Wom-блок (block)
const { blockWomBlock } = require('./skip-blocks/wom-block');

// Wom блок (inline)
const { inlineWomBlock } = require('./skip-blocks/wom-block');

// Wom-html (block)
const { blockWomHtml } = require('./skip-blocks/wom-html');

// Wom html (inline)
const { inlineWomHtml } = require('./skip-blocks/wom-html');

// Wom кат (block)
const { blockWomCut } = require('./skip-blocks/wom-cut');

// Wom кат (inline)
const { inlineWomCut } = require('./skip-blocks/wom-cut');

// Wom цитата (block)
const { blockWomBlockquote } = require('./skip-blocks/wom-blockquote');

// Wom цитата (inline)
const { inlineWomBlockquote } = require('./skip-blocks/wom-blockquote');

// Wom строчное экранирование (~)
const { stringWomEscape } = require('./skip-blocks/wom-escape');

// Wom блочное экранирование (inline)
const { inlineWomEscape } = require('./skip-blocks/wom-escape');

// Wom-monospace ##monospace##
const { womMonospace } = require('./skip-blocks/wom-monospace');

// Wom-таблица (block)
const { blockWomTable } = require('./skip-blocks/wom-table');

// Wom-таблица (inline)
const { inlineWomTable } = require('./skip-blocks/wom-table');

// Md форматтер кода (block)
const { blockMdCode } = require('./skip-blocks/md-code');

// Md форматтер кода (inline)
const { inlineMdCode } = require('./skip-blocks/md-code');

// Здесь порядок имеет значение!
const blocks = [
    blockWomMarkdown,
    blockWomFormatter,
    blockWomCut,
    blockWomBlockquote,
    blockWomBlock,
    blockWomHtml,
    blockWomTable,
    blockMdCode,
];

// Здесь порядок имеет значение!
const inlines = [
    womMonospace,
    inlineWomMarkdown,
    inlineWomFormatter,
    inlineWomCut,
    inlineWomBlockquote,
    inlineWomBlock,
    inlineWomHtml,
    inlineWomTable,
    inlineMdCode,
    stringWomEscape,
    inlineWomEscape,
];

// Здесь порядок имеет значение!
defaultBlockChildren.push(
    ...blocks,
    ...inlines,
);

// Здесь порядок имеет значение!
defaultInlineChildren.push(
    ...inlines,
);

exports.blocks = blocks;
exports.inlines = inlines;

exports.blockWomHtml = blockWomHtml;
exports.inlineWomHtml = inlineWomHtml;

exports.blockWomBlockquote = blockWomBlockquote;
exports.inlineWomBlockquote = inlineWomBlockquote;

exports.blockWomCut = blockWomCut;
exports.inlineWomCut = inlineWomCut;

exports.blockWomBlock = blockWomBlock;
exports.inlineWomBlock = inlineWomBlock;

exports.blockWomFormatter = blockWomFormatter;
exports.inlineWomFormatter = inlineWomFormatter;

exports.blockWomMarkdown = blockWomMarkdown;
exports.inlineWomMarkdown = inlineWomMarkdown;

exports.blockWomTable = blockWomTable;
exports.inlineWomTable = inlineWomTable;

exports.stringWomEscape = stringWomEscape;
exports.inlineWomEscape = inlineWomEscape;

exports.blockMdCode = blockMdCode;
exports.inlineMdCode = inlineMdCode;

exports.womMonospace = womMonospace;

exports.blockWomHtml = blockWomHtml;
exports.inlineWomHtml = inlineWomHtml;

exports.blockWomBlockquote = blockWomBlockquote;
exports.inlineWomBlockquote = inlineWomBlockquote;

exports.blockWomCut = blockWomCut;
exports.inlineWomCut = inlineWomCut;

exports.blockWomBlock = blockWomBlock;
exports.inlineWomBlock = inlineWomBlock;

exports.blockWomFormatter = blockWomFormatter;
exports.inlineWomFormatter = inlineWomFormatter;

exports.blockWomMarkdown = blockWomMarkdown;
exports.inlineWomMarkdown = inlineWomMarkdown;

exports.blockWomTable = blockWomTable;
exports.inlineWomTable = inlineWomTable;

exports.stringWomEscape = stringWomEscape;
exports.inlineWomEscape = inlineWomEscape;

exports.blockMdCode = blockMdCode;
exports.inlineMdCode = inlineMdCode;

exports.womMonospace = womMonospace;
