const { isEscaped } = require('../spec');
const {
    isLineOpening,
    skipLineFollowingSpacing,
} = require('../skip-blocks-utils');

const { defaultBlockChildren } = require('./possible-children');

// Wom цитата (block)
const blockWomBlockquote = {
    type: 'womBlockquote',
    inline: false,
    possibleChildren: defaultBlockChildren,
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Невозможно заэкранировать открывающий разделитель блока,
        // потому что перед ним всегда есть \n, либо он в самом начале строки.
        // Поэтому на экранирование не проверяем.
        // Проверка начала строки - ниже
        if (!(value[openingInitialIndex] === '<' && value[openingInitialIndex + 1] === '[')) {
            return;
        }

        const openingFollowingIndex = openingInitialIndex + 2;

        if (!isLineOpening(value, openingInitialIndex) || skipLineFollowingSpacing(value, openingFollowingIndex) < 0) {
            return;
        }

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingFollowingIndex;
        stateNode.innerFirstIndex = openingFollowingIndex;
    },
    matchClosing(value, closingInitialIndex, stateNode) {
        const l = value.length;

        if (l - closingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Закрывающий разделитель можно заэкранировать
        if (!(value[closingInitialIndex] === ']' && value[closingInitialIndex + 1] === '>') || isEscaped(value, closingInitialIndex)) {
            return;
        }

        const closingFollowingIndex = closingInitialIndex + 2;

        stateNode.closingInitialIndex = closingInitialIndex;
        stateNode.closingFollowingIndex = closingFollowingIndex;
        stateNode.outerFirstIndex = closingFollowingIndex;
    },
    enterSpacing() {},
    checkSpacing() {
        return true;
    },
};

// Wom цитата (inline)
const inlineWomBlockquote = {
    type: 'womBlockquote',
    inline: true,
    possibleChildren: defaultBlockChildren,
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Открывающий разделитель можно заэкранировать
        if (!(value[openingInitialIndex] === '<' && value[openingInitialIndex + 1] === '[') || isEscaped(value, openingInitialIndex)) {
            return;
        }

        const openingFollowingIndex = openingInitialIndex + 2;

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingFollowingIndex;
        stateNode.innerFirstIndex = openingFollowingIndex;
    },
    matchClosing: blockWomBlockquote.matchClosing,
    enterSpacing() {},
    checkSpacing() {
        return true;
    },
};

exports.blockWomBlockquote = blockWomBlockquote;
exports.inlineWomBlockquote = inlineWomBlockquote;
