const {
    isEscaped,
    isWhitespaceChar,
} = require('../spec');

// Wom строчное экранирование (~)
const stringWomEscape = {
    type: 'womEscape',
    inline: true,
    possibleChildren: [],
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Открывающий разделитель может быть заэкранирован
        if (
            value[openingInitialIndex] !== '~' ||
            isWhitespaceChar(value, openingInitialIndex + 1) ||
            isEscaped(value, openingInitialIndex)
        ) {
            return;
        }

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingInitialIndex + 1;
        stateNode.innerFirstIndex = openingInitialIndex + 1;
    },
    matchClosing(value, closingInitialIndex, stateNode) {
        if (value[closingInitialIndex] === '~') {
            // Экранирует либо ОДНУ тильду
            stateNode.closingInitialIndex = closingInitialIndex + 1;
            stateNode.closingFollowingIndex = closingInitialIndex + 1;
            stateNode.outerFirstIndex = closingInitialIndex + 1;

            return;
        }

        const l = value.length;

        // Либо ВСЮ ПОСЛЕДОВАТЕЛЬНОСТЬ непробельных символов
        // +1, потому что в матчинге на голову делается lookAhead на 1 символ,
        // который точно матчится
        let closingFollowingIndex = closingInitialIndex + 1;

        while (
            closingFollowingIndex < l &&
            (
                (
                    !isWhitespaceChar(value, closingFollowingIndex) &&
                    value[closingFollowingIndex] !== '~'
                ) ||
                isEscaped(value, closingFollowingIndex)
            )
        ) {
            closingFollowingIndex += 1;
        }

        stateNode.closingInitialIndex = closingFollowingIndex;
        stateNode.closingFollowingIndex = closingFollowingIndex;
        stateNode.outerFirstIndex = closingFollowingIndex;
    },
    enterSpacing() {},
    /* istanbul ignore next */
    checkSpacing() {
        // В stringWomEscape нет контента,
        // поэтому этот метод никогда не вызовется
        return true;
    },
};

// Wom блочное экранирование (inline)
const inlineWomEscape = {
    type: 'womEscape',
    inline: true,
    possibleChildren: [],
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Открывающий разделитель может быть заэкранирован
        if (!(value[openingInitialIndex] === '"' && value[openingInitialIndex + 1] === '"') || isEscaped(value, openingInitialIndex)) {
            return;
        }

        const openingFollowingIndex = openingInitialIndex + 2;

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingFollowingIndex;
        stateNode.innerFirstIndex = openingFollowingIndex;
    },
    matchClosing(value, closingInitialIndex, stateNode) {
        const l = value.length;

        if (l - closingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Закрывающий разделитель нельзя заэкранировать
        if (!(value[closingInitialIndex] === '"' && value[closingInitialIndex + 1] === '"')) {
            return;
        }

        const closingFollowingIndex = closingInitialIndex + 2;

        stateNode.closingInitialIndex = closingInitialIndex;
        stateNode.closingFollowingIndex = closingFollowingIndex;
        stateNode.outerFirstIndex = closingFollowingIndex;
    },
    enterSpacing() {},
    checkSpacing() {
        return true;
    },
};

exports.stringWomEscape = stringWomEscape;
exports.inlineWomEscape = inlineWomEscape;
