const { isEscaped } = require('../spec');
const { isLineOpening } = require('../skip-blocks-utils');

// Wom-html (block)
const blockWomHtml = {
    type: 'womHtml',
    inline: false,
    possibleChildren: [],
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Невозможно заэкранировать открывающий разделитель блока,
        // потому что перед ним всегда есть \n, либо он в самом начале строки.
        // Поэтому на экранирование не проверяем.
        // Проверка начала строки - ниже
        if (!(value[openingInitialIndex] === '<' && value[openingInitialIndex + 1] === '#')) {
            return;
        }

        // womHtml даже когда написан в одну строку является блочным.
        // Единственное условие - быть в начале строки
        if (!isLineOpening(value, openingInitialIndex)) {
            return;
        }

        const openingFollowingIndex = openingInitialIndex + 2;

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingFollowingIndex;
        stateNode.innerFirstIndex = openingFollowingIndex;
    },
    matchClosing(value, closingInitialIndex, stateNode) {
        const l = value.length;

        if (l - closingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Закрывающий разделитель нельзя заэкранировать
        if (!(value[closingInitialIndex] === '#' && value[closingInitialIndex + 1] === '>')) {
            return;
        }

        const closingFollowingIndex = closingInitialIndex + 2;

        stateNode.closingInitialIndex = closingInitialIndex;
        stateNode.closingFollowingIndex = closingFollowingIndex;
        stateNode.outerFirstIndex = closingFollowingIndex;
    },
    enterSpacing() {},
    checkSpacing() {
        return true;
    },
};

// Wom html (inline)
const inlineWomHtml = {
    type: 'womHtml',
    inline: true,
    possibleChildren: [],
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Открывающий разделитель можно заэкранировать
        if (!(value[openingInitialIndex] === '<' && value[openingInitialIndex + 1] === '#') || isEscaped(value, openingInitialIndex)) {
            return;
        }

        const openingFollowingIndex = openingInitialIndex + 2;

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingFollowingIndex;
        stateNode.innerFirstIndex = openingFollowingIndex;
    },
    matchClosing: blockWomHtml.matchClosing,
    enterSpacing() {},
    checkSpacing() {
        return true;
    },
};

exports.blockWomHtml = blockWomHtml;
exports.inlineWomHtml = inlineWomHtml;
