const {
    isEscaped,
    isCommonmarkWhitespace,
} = require('../spec');
const { defaultInlineChildren } = require('./possible-children');

// Wom-monospace ##monospace##
const womMonospace = {
    type: 'womMonospace',
    inline: true,
    possibleChildren: defaultInlineChildren,
    matchOpening(value, openingInitialIndex, stateNode) {
        const l = value.length;

        if (l - openingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Открывающий разделитель может быть заэкранирован
        if (!(value[openingInitialIndex] === '#' && value[openingInitialIndex + 1] === '#') || isEscaped(value, openingInitialIndex)) {
            return;
        }

        if (isCommonmarkWhitespace(value, openingInitialIndex + 2)) {
            return;
        }

        stateNode.openingInitialIndex = openingInitialIndex;
        stateNode.openingFollowingIndex = openingInitialIndex + 2;
        stateNode.innerFirstIndex = openingInitialIndex + 2;
    },
    matchClosing(value, closingInitialIndex, stateNode) {
        const l = value.length;

        if (l - closingInitialIndex < 2) {
            // Bounds check, avoiding eager v8 deopt
            return;
        }

        // Закрывающий разделитель может быть заэкранирован
        if (!(value[closingInitialIndex] === '#' && value[closingInitialIndex + 1] === '#') || isEscaped(value, closingInitialIndex)) {
            return;
        }

        if (isCommonmarkWhitespace(value, closingInitialIndex - 1)) {
            return;
        }

        stateNode.closingInitialIndex = closingInitialIndex;
        stateNode.closingFollowingIndex = closingInitialIndex + 2;
        stateNode.outerFirstIndex = closingInitialIndex + 2;
    },
    enterSpacing() {},
    checkSpacing() {
        return true;
    },
};

exports.womMonospace = womMonospace;
