const { expect } = require('chai');
const { isEscaped } = require('./spec');

describe('isEscaped()', () => {
    it('Should check if char escaped by \\', () => {
        expect(isEscaped('\\1', 1))
            .to.equal(true);

        expect(isEscaped('\\1', 0))
            .to.equal(false);

        expect(isEscaped('\\1', 2))
            .to.equal(false);

        expect(isEscaped('\\\\1', 2))
            .to.equal(false);

        expect(isEscaped('1\\\\1', 3))
            .to.equal(false);

        expect(isEscaped('\\\\1', 1))
            .to.equal(true);

        expect(isEscaped('1\\\\1', 2))
            .to.equal(true);

        expect(isEscaped('\\\\\\1', 3))
            .to.equal(true);

        expect(isEscaped('1\\\\\\1', 4))
            .to.equal(true);
    });
});
