import { RefObject } from 'react';
import { ReactDatePickerProps } from 'react-datepicker';
import './Datepicker.css';
export * from './Datepicker.classname';
/**
 * Все доступные свойства Textinput.
 */
declare type TextinputProps = import('@yandex-lego/components/Textinput/desktop/bundle').ITextinputProps;
/**
 * Свойства наследуемые у Textinput.
 */
declare type TextinputInheritedProps = Pick<TextinputProps, 'size' | 'theme' | 'view' | 'pin' | 'state' | 'hint'>;
export declare const i18n: (key: string, options?: Record<string, string | number | object | undefined> | import("@yandex-int/i18n").I18nPluralOptions | undefined) => string;
/**
 * Позиционирование попапа дейтпикера.
 * https://popper.js.org/docs/v1/#Popper.placements
 */
export declare type Direction = 'auto' | 'top' | 'right' | 'bottom' | 'left' | 'auto-start' | 'top-start' | 'right-start' | 'bottom-start' | 'left-start' | 'auto-end' | 'top-end' | 'right-end' | 'bottom-end' | 'left-end';
/**
 * Формат парсинга даты по-умолчанию
 */
export declare const DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
/**
 * Формат отображения даты по-умолчанию
 */
export declare const DEFAULT_DISPLAY_FORMAT = "dd.MM.yyyy";
/**
 * Параметры компонента.
 */
export interface DatepickerProps extends TextinputInheritedProps {
    ariaLabelledBy?: string;
    autoComplete?: string;
    autoFocus?: boolean;
    className?: string;
    controlRef?: RefObject<HTMLInputElement>;
    disabled?: boolean;
    id?: string;
    min?: Date;
    max?: Date;
    name?: string;
    onBlur?(event: React.FocusEvent<HTMLInputElement>): void;
    /**
     * Обработчик изменения текста в поле.
     * Обратите внимание, что для получения значения используется onDateChange().
     * Поведение onChange отличается между desktop, touch-pad и touch-phone.
     */
    onChange?(event: React.ChangeEvent<HTMLInputElement>): void;
    onFocus?(event: React.FocusEvent<HTMLInputElement>): void;
    onKeyDown?(event: React.KeyboardEvent<HTMLDivElement>): void;
    placeholder?: string;
    readOnly?: boolean;
    required?: boolean;
    tabIndex?: number;
    title?: string;
    value?: Date;
    /** Обработчик изменения даты */
    onDateChange?(date: Date | null): void;
    /** Запрет открытия дейтпикера при фокусировке на desktop */
    preventOpenOnFocus?: boolean;
    /** Формат отображения даты в поле на desktop и touch-pad */
    dateFormat?: string;
    /** Позиционирование попапа дейтпикера. @default 'bottom' */
    direction?: Direction;
    preventOverflow?: boolean | NonNullable<ReactDatePickerProps['popperModifiers']>['preventOverflow'];
    overflowPadding?: NonNullable<NonNullable<ReactDatePickerProps['popperModifiers']>['preventOverflow']>['padding'];
    /**
     * Включает изменение даты при переключении месяца, года или управления с клавиатуры
     * @default true
     */
    adjustDateOnChange?: boolean;
}
/**
 * Получение локали в зависимости от языка заданного @yandex-int/i18n.
 *
 * @returns {Locale}
 */
export declare function getLocale(): Locale;
/**
 * Форматирование значения value, min и max в строку.
 * Используется для перевода объекта даты в текст на уровне переопределения touch-phone.
 * Может пригодиться при реализации обертки.
 *
 * @param {Date | null | undefined} date Дата.
 * @param {String} format Формат даты. По-умолчанию yyyy-MM-dd.
 */
export declare function formatDate(date: Date | null | undefined, format?: string): string | undefined;
/**
 * Парсинг текстового значения даты в объект Date.
 * Используется для перевода текста в объекта даты на уровне переопределения touch-phone.
 * Может пригодиться при реализации обертки.
 *
 * @param {String | null | undefined} dateValue Значение даты.
 * @param {String} format Формат даты. По-умолчанию yyyy-MM-dd.
 */
export declare function parseDate(dateValue: string | null | undefined, format?: string): Date | undefined;
/**
 * Временное решение пока dist-ts-generator не научится выгружать хуки
 *
 * @deprecated
 */
export * from '../../hooks/useDatepickerStringDates';
