"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var i18n_1 = tslib_1.__importStar(require("@yandex-int/i18n"));
var parse_1 = tslib_1.__importDefault(require("date-fns/parse"));
var format_1 = tslib_1.__importDefault(require("date-fns/format"));
var isValid_1 = tslib_1.__importDefault(require("date-fns/isValid"));
var locales = tslib_1.__importStar(require("./DatepickerLocale.i18n"));
var keyset = tslib_1.__importStar(require("./Datepicker.i18n"));
require("./Datepicker.css");
tslib_1.__exportStar(require("./Datepicker.classname"), exports);
/**
 * Генерация даты, для date-fns/parse, для задания времени 00:00:00
 *
 * Вывод: Sat Jan 01 2000 00:00:00 GMT+0300 (Moscow Standard Time)
 */
var dateFnsBackupDate = new Date(Date.UTC(1995, 4, 13, 0, 0, 0, 0));
exports.i18n = i18n_1.default(keyset);
/**
 * Формат парсинга даты по-умолчанию
 */
exports.DEFAULT_DATE_FORMAT = 'yyyy-MM-dd';
/**
 * Формат отображения даты по-умолчанию
 */
exports.DEFAULT_DISPLAY_FORMAT = 'dd.MM.yyyy';
/**
 * Получение локали в зависимости от языка заданного @yandex-int/i18n.
 *
 * @returns {Locale}
 */
function getLocale() {
    return locales[i18n_1.getI18nLang()] || locales.ru;
}
exports.getLocale = getLocale;
/**
 * Форматирование значения value, min и max в строку.
 * Используется для перевода объекта даты в текст на уровне переопределения touch-phone.
 * Может пригодиться при реализации обертки.
 *
 * @param {Date | null | undefined} date Дата.
 * @param {String} format Формат даты. По-умолчанию yyyy-MM-dd.
 */
function formatDate(date, format) {
    if (format === void 0) { format = exports.DEFAULT_DATE_FORMAT; }
    if (date && isValid_1.default(date)) {
        return format_1.default(date, format, { locale: getLocale() });
    }
    return undefined;
}
exports.formatDate = formatDate;
/**
 * Парсинг текстового значения даты в объект Date.
 * Используется для перевода текста в объекта даты на уровне переопределения touch-phone.
 * Может пригодиться при реализации обертки.
 *
 * @param {String | null | undefined} dateValue Значение даты.
 * @param {String} format Формат даты. По-умолчанию yyyy-MM-dd.
 */
function parseDate(dateValue, format) {
    if (format === void 0) { format = exports.DEFAULT_DATE_FORMAT; }
    var value = typeof dateValue === 'string' ? dateValue.trim() : '';
    if (!value) {
        return undefined;
    }
    var date = parse_1.default(value, format, dateFnsBackupDate, { locale: getLocale() });
    if (isValid_1.default(date)) {
        return date;
    }
    throw new Error("\u041F\u0440\u0438 \u043F\u0430\u0440\u0441\u0438\u043D\u0433\u0435 \u0434\u0430\u0442\u044B \u043F\u0440\u043E\u0438\u0437\u043E\u0448\u043B\u0430 \u043E\u0448\u0438\u0431\u043A\u0430.\n\u0422\u0435\u043A\u0443\u0449\u0435\u0435 \u0437\u043D\u0430\u0447\u0435\u043D\u0438\u0435 \"" + dateValue + ". \u0418\u0441\u043F\u043E\u043B\u044C\u0437\u0443\u0435\u043C\u044B\u0439 \u0444\u043E\u0440\u043C\u0430\u0442 \"" + format + "\"");
}
exports.parseDate = parseDate;
/**
 * Временное решение пока dist-ts-generator не научится выгружать хуки
 *
 * @deprecated
 */
tslib_1.__exportStar(require("../../hooks/useDatepickerStringDates"), exports);
