"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var di_1 = require("@bem-react/di");
var isAfter_1 = tslib_1.__importDefault(require("date-fns/isAfter"));
var isBefore_1 = tslib_1.__importDefault(require("date-fns/isBefore"));
var Datepicker_1 = require("./Datepicker");
var touch_phone_1 = require("./Datepicker.registry/touch-phone");
tslib_1.__exportStar(require("./Datepicker"), exports);
var DatepickerPresenter = function (_a) {
    var className = _a.className, dateFormat = _a.dateFormat, max = _a.max, min = _a.min, onBlur = _a.onBlur, onChange = _a.onChange, onDateChange = _a.onDateChange, preventOpenOnFocus = _a.preventOpenOnFocus, value = _a.value, direction = _a.direction, props = tslib_1.__rest(_a, ["className", "dateFormat", "max", "min", "onBlur", "onChange", "onDateChange", "preventOpenOnFocus", "value", "direction"]);
    /** Защита от ввода значений вне диапазона разрешенных */
    var handleBlur = react_1.useCallback(function (event) {
        if (onDateChange && value) {
            if (min && isBefore_1.default(value, min)) {
                onDateChange(min);
                return;
            }
            if (max && isAfter_1.default(value, max)) {
                onDateChange(max);
                return;
            }
        }
        if (onBlur) {
            onBlur(event);
        }
    }, [Datepicker_1.formatDate(value), Datepicker_1.formatDate(min), Datepicker_1.formatDate(max)]);
    /** Обработчик изменения поля с форматированием значения в дату */
    var handleChange = react_1.useCallback(function (event) {
        if (onChange) {
            onChange(event);
        }
        if (onDateChange) {
            var value_1 = event.target.value.trim();
            if (!value_1) {
                onDateChange(null);
                return;
            }
            try {
                var date = Datepicker_1.parseDate(value_1);
                onDateChange(date || null);
            }
            catch (error) {
            }
        }
    }, [onChange, onDateChange]);
    var _b = di_1.useComponentRegistry(Datepicker_1.cnDatepicker()), Textinput = _b.Textinput, CalendarIcon = _b.CalendarIcon;
    return (react_1.default.createElement(Textinput, tslib_1.__assign({}, props, { className: Datepicker_1.cnDatepicker({ view: props.view }, [className]), value: Datepicker_1.formatDate(value), min: Datepicker_1.formatDate(min), max: Datepicker_1.formatDate(max), onChange: handleChange, onBlur: handleBlur, type: "date", baseline: true, iconRight: react_1.default.createElement(CalendarIcon, { type: "calendar" }) })));
};
exports.Datepicker = di_1.withRegistry(touch_phone_1.datepickerRegistry)(DatepickerPresenter);
