"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importStar(require("react"));
var react_dom_1 = require("react-dom");
var react_datepicker_1 = tslib_1.__importDefault(require("react-datepicker"));
var di_1 = require("@bem-react/di");
var isValid_1 = tslib_1.__importDefault(require("date-fns/isValid"));
var canUseDOM_1 = require("../../../lib/canUseDOM");
var Datepicker_1 = require("../Datepicker");
require("./ReactDatepicker.raw.css");
var noop = function () { };
var PopperPortal = function (_a) {
    var children = _a.children;
    if (!canUseDOM_1.canUseDOM()) {
        return null;
    }
    return react_dom_1.createPortal(children, document.body);
};
exports.ReactDatepicker = function (_a) {
    var pin = _a.pin, size = _a.size, theme = _a.theme, view = _a.view, state = _a.state, hint = _a.hint, ariaLabelledBy = _a.ariaLabelledBy, autoComplete = _a.autoComplete, autoFocus = _a.autoFocus, className = _a.className, controlRef = _a.controlRef, direction = _a.direction, preventOverflow = _a.preventOverflow, overflowPadding = _a.overflowPadding, disabled = _a.disabled, id = _a.id, min = _a.min, max = _a.max, name = _a.name, onBlur = _a.onBlur, onChange = _a.onChange, onDateChange = _a.onDateChange, onFocus = _a.onFocus, onKeyDown = _a.onKeyDown, placeholder = _a.placeholder, readOnly = _a.readOnly, required = _a.required, tabIndex = _a.tabIndex, title = _a.title, value = _a.value, _b = _a.dateFormat, dateFormat = _b === void 0 ? Datepicker_1.DEFAULT_DISPLAY_FORMAT : _b, preventOpenOnFocus = _a.preventOpenOnFocus, _c = _a.adjustDateOnChange, adjustDateOnChange = _c === void 0 ? true : _c;
    var _d = di_1.useComponentRegistry(Datepicker_1.cnDatepicker()), Textinput = _d.Textinput, CalendarIcon = _d.CalendarIcon;
    var calendarIcon = react_1.useMemo(function () {
        return (react_1.default.createElement(CalendarIcon, { size: size, type: "calendar" }));
    }, [size]);
    var popperModifiers = {};
    var padding;
    if (overflowPadding) {
        padding = { padding: overflowPadding };
    }
    if (preventOverflow === true) {
        popperModifiers.preventOverflow = tslib_1.__assign({ enabled: true, boundariesElement: 'viewport' }, padding);
    }
    else if (typeof preventOverflow === 'object') {
        popperModifiers.preventOverflow = preventOverflow;
    }
    return (react_1.default.createElement("div", { className: Datepicker_1.cnDatepicker({ view: view }, [className]) },
        react_1.default.createElement(react_datepicker_1.default, { ariaLabelledBy: ariaLabelledBy, autoComplete: autoComplete, autoFocus: autoFocus, dateFormat: dateFormat, disabled: disabled, id: id, locale: Datepicker_1.getLocale(), 
            // Если возвращать null вместо undefined для даты, перестает работать управление с клавиатуры
            maxDate: max && isValid_1.default(max) ? max : undefined, minDate: min && isValid_1.default(min) ? min : undefined, name: name, onBlur: onBlur, onChange: onDateChange || noop, onChangeRaw: onChange, onFocus: onFocus, onKeyDown: onKeyDown, placeholderText: placeholder, popperPlacement: direction, popperModifiers: preventOverflow ? popperModifiers : undefined, preventOpenOnFocus: preventOpenOnFocus, readOnly: readOnly, required: required, selected: value && isValid_1.default(value) ? value : null, tabIndex: tabIndex, title: title, 
            // Переводы
            previousMonthButtonLabel: Datepicker_1.i18n('previousMonthButtonLabel'), nextMonthButtonLabel: Datepicker_1.i18n('nextMonthButtonLabel'), previousYearButtonLabel: Datepicker_1.i18n('previousYearButtonLabel'), nextYearButtonLabel: Datepicker_1.i18n('nextYearButtonLabel'), 
            // Свойства отвечающие за визуальное представление
            adjustDateOnChange: adjustDateOnChange, peekNextMonth: true, popperContainer: PopperPortal, showMonthDropdown: true, showPopperArrow: false, showYearDropdown: true, strictParsing: true, customInput: react_1.default.createElement(Textinput, { pin: pin, size: size, theme: theme, view: view, state: state, hint: hint, controlRef: controlRef, baseline: true, iconRight: calendarIcon }), customInputRef: "innerRef" // Textinput
         })));
};
