"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var di_1 = require("@bem-react/di");
var Informer_registry_1 = require("./Informer.registry");
var Informer_classname_1 = require("./Informer.classname");
require("./Informer.css");
var Informer = function (props) {
    var _a = di_1.useComponentRegistry(Informer_registry_1.informerRegistryId), MessageBox = _a.MessageBox, Button = _a.Button, Corner = _a.Corner;
    var data = props.data, lang = props.lang, _b = props.onClose, onClose = _b === void 0 ? function () { } : _b, className = props.className;
    var handleButtonClick = react_1.default.useCallback(function () {
        onClose({ withAction: Boolean(data.button.link) });
    }, [onClose, data.button.link]);
    var handleClose = react_1.default.useCallback(function () {
        onClose({ withAction: false });
    }, [onClose]);
    return (react_1.default.createElement(MessageBox, { className: Informer_classname_1.cnInformer({}, [className]), view: "promo", size: "l", layout: "functional", actions: react_1.default.createElement(react_1.default.Fragment, null,
            data.button.link && (react_1.default.createElement(Button, { size: "m", type: "link", view: "action", url: data.button.link, target: "_blank", onClick: handleButtonClick }, data.button.text[lang])),
            !data.button.link && (react_1.default.createElement(Button, { size: "m", view: "default", onClick: handleButtonClick }, data.button.text[lang]))), corner: react_1.default.createElement(Corner, { width: 55, side: "top-left" },
            react_1.default.createElement("img", { className: Informer_classname_1.cnInformer('Icon'), src: data.iconUrl })), onClose: handleClose },
        react_1.default.createElement("div", { className: Informer_classname_1.cnInformer('Content') },
            react_1.default.createElement("div", { className: Informer_classname_1.cnInformer('Title') }, data.title[lang]),
            react_1.default.createElement("div", { className: Informer_classname_1.cnInformer('Text') }, data.text[lang]))));
};
exports.Informer = Informer;
