"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var react_1 = tslib_1.__importDefault(require("react"));
var di_1 = require("@bem-react/di");
var InformerContainer_registry_1 = require("./InformerContainer.registry");
var setLsItem = function (key, val) {
    try {
        localStorage.setItem(key, val);
    }
    catch (error) {
        console.error(error);
    }
};
var getLsItem = function (key) {
    try {
        return localStorage.getItem(key);
    }
    catch (error) {
        console.error(error);
    }
    return null;
};
var getStorage = function (keyEpoch) {
    try {
        var storage = getLsItem("informers_" + keyEpoch);
        if (typeof storage === 'string') {
            return JSON.parse(storage);
        }
    }
    catch (error) {
        console.error(error);
    }
    return { informers: {} };
};
var setStorage = function (keyEpoch, storage) {
    try {
        setLsItem("informers_" + keyEpoch, JSON.stringify(storage));
    }
    catch (error) {
        console.error(error);
    }
};
var randomInt = function (min, max) {
    return Math.floor(min + Math.random() * (max + 1 - min));
};
var debug = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    if (getLsItem('LOG_LEVEL') === 'debug') {
        // eslint-disable-next-line no-console
        console.debug.apply(console, tslib_1.__spread(args));
    }
};
var waitForInformerSlot = function (manifest) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
    var keyEpoch, informerInterval, storage, theLateShow, _a, _b, informerShowInfo, lastShow, timeToWait;
    var e_1, _c;
    return tslib_1.__generator(this, function (_d) {
        switch (_d.label) {
            case 0:
                keyEpoch = manifest.keyEpoch, informerInterval = manifest.informerInterval;
                storage = getStorage(keyEpoch);
                theLateShow = 0;
                try {
                    for (_a = tslib_1.__values(Object.values(storage.informers)), _b = _a.next(); !_b.done; _b = _a.next()) {
                        informerShowInfo = _b.value;
                        lastShow = informerShowInfo.lastShow;
                        if (lastShow > theLateShow) {
                            theLateShow = lastShow;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                timeToWait = Math.max(0, theLateShow + informerInterval * 60000 - Date.now());
                if (timeToWait === 0) {
                    debug('[Informer] Got informer slot');
                    // Уже можно
                    return [2 /*return*/];
                }
                debug("[Informer] Wait for informer slot " + timeToWait + "ms");
                // Если выясняется, что пока что никакой информер показать нельзя,
                // то ждем время до возможного показа и делаем проверку снова
                return [4 /*yield*/, new Promise(function (resolve) {
                        setTimeout(resolve, timeToWait);
                    })];
            case 1:
                // Если выясняется, что пока что никакой информер показать нельзя,
                // то ждем время до возможного показа и делаем проверку снова
                _d.sent();
                return [4 /*yield*/, waitForInformerSlot(manifest)];
            case 2:
                _d.sent();
                return [2 /*return*/];
        }
    });
}); };
var unlockInformers = function (manifest) { return tslib_1.__awaiter(void 0, void 0, void 0, function () {
    var keyEpoch, storage, actualInformers, informers, minTimeToWait, informers_1, informers_1_1, informer, informerShowInfo, currentInformerTimeout, isClosed, lastShow, timeToWait;
    var e_2, _a;
    return tslib_1.__generator(this, function (_b) {
        switch (_b.label) {
            case 0: 
            // Между показами любых информеров есть минимальный гигиенический таймаут,
            // пользователи не должны видеть информеры чаще чем это время: informerInterval (указывается в минутах)
            return [4 /*yield*/, waitForInformerSlot(manifest)];
            case 1:
                // Между показами любых информеров есть минимальный гигиенический таймаут,
                // пользователи не должны видеть информеры чаще чем это время: informerInterval (указывается в минутах)
                _b.sent();
                keyEpoch = manifest.keyEpoch;
                storage = getStorage(keyEpoch);
                actualInformers = [];
                informers = manifest.informers;
                minTimeToWait = Infinity;
                try {
                    for (informers_1 = tslib_1.__values(informers), informers_1_1 = informers_1.next(); !informers_1_1.done; informers_1_1 = informers_1.next()) {
                        informer = informers_1_1.value;
                        informerShowInfo = storage.informers[informer.id];
                        if (informerShowInfo) {
                            currentInformerTimeout = informer.currentInformerTimeout;
                            isClosed = informerShowInfo.isClosed, lastShow = informerShowInfo.lastShow;
                            if (isClosed) {
                                // Этот информер был скрыт явно и навсегда,
                                // мы больше никогда его не покажем
                                continue;
                            }
                            timeToWait = Math.max(0, lastShow + currentInformerTimeout * 60000 - Date.now());
                            if (timeToWait > 0) {
                                // Этот информер был показан ранее, но не был закрыт явно,
                                // был проигнорирован, однако, его еще нельзя показывать.
                                // PS: currentInformerTimeout указывается в минутах
                                if (timeToWait < minTimeToWait) {
                                    minTimeToWait = timeToWait;
                                }
                                continue;
                            }
                        }
                        // Если нет никаких данных о показе информера,
                        // значит он никогда не был показан ранее
                        actualInformers.push(informer);
                    }
                }
                catch (e_2_1) { e_2 = { error: e_2_1 }; }
                finally {
                    try {
                        if (informers_1_1 && !informers_1_1.done && (_a = informers_1.return)) _a.call(informers_1);
                    }
                    finally { if (e_2) throw e_2.error; }
                }
                if (actualInformers.length > 0) {
                    debug("[Informer] Got " + actualInformers.length + " actual informers");
                    return [2 /*return*/, actualInformers];
                }
                if (!isFinite(minTimeToWait)) return [3 /*break*/, 3];
                // Добавим несколько секунд к minTimeToWait,
                // чтобы не было такого, что на разных вкладках
                // процесс ожидает одинаковое время
                minTimeToWait += randomInt(1000, 5000);
                debug("[Informer] Wait for actual informer " + minTimeToWait + "ms");
                // В случае 3 мы подождем,
                // пока не подойдет самый ближайший по времени информер
                // и запустим весь механизм снова
                return [4 /*yield*/, new Promise(function (resolve) {
                        setTimeout(resolve, minTimeToWait);
                    })];
            case 2:
                // В случае 3 мы подождем,
                // пока не подойдет самый ближайший по времени информер
                // и запустим весь механизм снова
                _b.sent();
                return [2 /*return*/, unlockInformers(manifest)];
            case 3:
                debug('[Informer] No actual informers.');
                return [2 /*return*/, actualInformers];
        }
    });
}); };
var InformerRotation = /** @class */ (function () {
    function InformerRotation(params) {
        this.params = params;
        this.firstShowTimeoutPromise = undefined;
        this.nextInformerPromise = Promise.resolve();
        this.currInformerInterval = undefined;
    }
    InformerRotation.prototype.fetchManifest = function () {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var _a, route, node, lang, res, result;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.params, route = _a.route, node = _a.node, lang = _a.lang;
                        return [4 /*yield*/, fetch(route + "/informer?node=" + node + "&lang=" + lang)];
                    case 1:
                        res = _b.sent();
                        return [4 /*yield*/, res.json()];
                    case 2:
                        result = (_b.sent()).result;
                        return [2 /*return*/, result];
                }
            });
        });
    };
    // Возвращает данные информера для показа или undefined
    InformerRotation.prototype.showInformer = function () {
        var _this = this;
        var nextInformerPromise = this.nextInformerPromise.then(function () { return tslib_1.__awaiter(_this, void 0, void 0, function () {
            var manifest, beforeShowTimeout, actualInformers, keyEpoch, informer, syncLastShow;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.fetchManifest()];
                    case 1:
                        manifest = _a.sent();
                        beforeShowTimeout = manifest.beforeShowTimeout;
                        // beforeShowTimeout (s) - время перед первым показом информера на странице,
                        // чтобы они появлялись не сразу, а через какое-то время после захода
                        if (!this.firstShowTimeoutPromise) {
                            this.firstShowTimeoutPromise = new Promise(function (resolve) {
                                debug("[Informer] Wait first show timeout " + beforeShowTimeout * 1000 + "ms");
                                // beforeShowTimeout указывается в секундах
                                setTimeout(resolve, beforeShowTimeout * 1000);
                            });
                        }
                        // Ожидаю это время,
                        // это отработает только для самого первого показа на странице
                        return [4 /*yield*/, this.firstShowTimeoutPromise];
                    case 2:
                        // Ожидаю это время,
                        // это отработает только для самого первого показа на странице
                        _a.sent();
                        return [4 /*yield*/, unlockInformers(manifest)];
                    case 3:
                        actualInformers = _a.sent();
                        if (actualInformers.length === 0) {
                            // Их нет.
                            // Такое может быть только в том случае, если все информеры уже показаны,
                            // либо ни один информер не сконфигурирован в админке
                            return [2 /*return*/, undefined];
                        }
                        keyEpoch = manifest.keyEpoch;
                        informer = actualInformers[Math.round(Math.random() * actualInformers.length - 0.5)];
                        syncLastShow = function () {
                            var _a;
                            var storage = getStorage(keyEpoch);
                            // Записываем в показанный информер текущее время,
                            // как время последнего показа
                            setStorage(keyEpoch, tslib_1.__assign(tslib_1.__assign({}, storage), { informers: tslib_1.__assign(tslib_1.__assign({}, storage.informers), (_a = {}, _a[informer.id] = tslib_1.__assign(tslib_1.__assign({}, storage.informers[informer.id]), { lastShow: Date.now() }), _a)) }));
                        };
                        syncLastShow();
                        // Раз в секунду (магическое число) синхронизирую текущее время
                        // со временем последнего показа текущего информера
                        this.currInformerInterval = setInterval(syncLastShow, 1000);
                        return [2 /*return*/, { keyEpoch: keyEpoch, informer: informer }];
                }
            });
        }); });
        this.nextInformerPromise = nextInformerPromise.then(function () { }, function (error) {
            // Чтобы не застопорить очередь,
            // игнорирую любые ошибки получения предыдущего информера
            console.error(error);
        });
        return nextInformerPromise;
    };
    // Скрывает информер
    InformerRotation.prototype.hideInformer = function (informerResult) {
        var _a;
        if (this.currInformerInterval !== undefined) {
            clearInterval(this.currInformerInterval);
        }
        // Если showInformer не допускает показа одинаковых информеров на разных вкладках,
        // то нет необходимости уметь скрывать одинаковый информер сразу на всех вкладках
        var keyEpoch = informerResult.keyEpoch, informer = informerResult.informer;
        var storage = getStorage(keyEpoch);
        setStorage(keyEpoch, tslib_1.__assign(tslib_1.__assign({}, storage), { informers: tslib_1.__assign(tslib_1.__assign({}, storage.informers), (_a = {}, _a[informer.id] = tslib_1.__assign(tslib_1.__assign({}, storage.informers[informer.id]), { isClosed: true, lastShow: Date.now() }), _a)) }));
    };
    return InformerRotation;
}());
var noop = function () { };
var InformerContainer = function (props) {
    var Informer = di_1.useComponentRegistry(InformerContainer_registry_1.informerContainerRegistryId).Informer;
    var route = props.route, node = props.node, _a = props.lang, lang = _a === void 0 ? 'ru' : _a, _b = props.onClose, onClose = _b === void 0 ? noop : _b, _c = props.onAction, onAction = _c === void 0 ? noop : _c, _d = props.onShow, onShow = _d === void 0 ? noop : _d, className = props.className;
    var rotation = react_1.default.useMemo(function () {
        return new InformerRotation({ route: route, node: node, lang: lang });
    }, [route, node, lang]);
    var _e = tslib_1.__read(react_1.default.useState(), 2), informerResult = _e[0], setInformerResult = _e[1];
    var handleClose = react_1.default.useCallback(function (_a) {
        var withAction = _a.withAction;
        // Здесь informerResult всегда есть,
        // потому что этот колбэк может вызваться только если из
        // informerResult отрендерить Informer
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        var id = informerResult.informer.id;
        if (withAction) {
            onAction(id);
        }
        else {
            onClose(id);
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        rotation.hideInformer(informerResult);
        setInformerResult(undefined);
        rotation.showInformer().then(setInformerResult);
    }, [onAction, onClose, informerResult, rotation, setInformerResult]);
    react_1.default.useEffect(function () {
        if (!informerResult) {
            return;
        }
        onShow(informerResult.informer.id);
    }, [informerResult, onShow]);
    react_1.default.useEffect(function () {
        rotation.showInformer().then(setInformerResult);
    }, [rotation, setInformerResult]);
    if (!informerResult) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    return (react_1.default.createElement(Informer, { className: className, data: informerResult.informer, lang: lang, onClose: handleClose }));
};
exports.InformerContainer = InformerContainer;
